/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.io.stream.WrappedWriter;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingWriter
extends WrappedWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingWriter.class);
    private long m_nTotalBytesWritten = 0L;

    public LoggingWriter(@Nonnull Writer writer) {
        super(writer);
    }

    @Nonnegative
    public final long getBytesWritten() {
        return this.m_nTotalBytesWritten;
    }

    @OverrideOnDemand
    protected void onWrite(@Nonnegative int n, long l) {
        LOGGER.info("Wrote " + n + " char(s); now at " + l);
    }

    @OverrideOnDemand
    protected void onClose(long l) {
        LOGGER.info("Close at " + l);
    }

    @Override
    public final void write(int n) throws IOException {
        super.write(n);
        ++this.m_nTotalBytesWritten;
        this.onWrite(1, this.m_nTotalBytesWritten);
    }

    @Override
    public final void write(@Nonnull char[] cArray, int n, int n2) throws IOException {
        super.write(cArray, n, n2);
        this.m_nTotalBytesWritten += (long)n2;
        this.onWrite(n2, this.m_nTotalBytesWritten);
    }

    @Override
    public final void close() throws IOException {
        super.close();
        this.onClose(this.m_nTotalBytesWritten);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("totalBytesWritten", this.m_nTotalBytesWritten).getToString();
    }
}

