/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.office;

import com.healthmarketscience.jackcess.cryptmodel.CTEncryption;
import com.healthmarketscience.jackcess.cryptmodel.password.CTPasswordKeyEncryptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.MD4Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.WhirlpoolDigest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEncryptionDescriptor {
    private static final String ENCRYPT_CONTEXT_NAME = "com.healthmarketscience.jackcess.cryptmodel";
    private static final String PASSWORD_ENCRYPTOR_CONTEXT_NAME = "com.healthmarketscience.jackcess.cryptmodel.password";

    private XmlEncryptionDescriptor() {
    }

    public static final CTEncryption parseEncryptionDescriptor(byte[] xmlBytes) {
        try {
            return (CTEncryption)XmlEncryptionDescriptor.unwrap(Encypt.CONTEXT.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlBytes)));
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Failed parsing encryption descriptor", e);
        }
    }

    public static final CTPasswordKeyEncryptor parsePasswordKeyEncryptor(Object keyDescriptor) {
        try {
            return (CTPasswordKeyEncryptor)XmlEncryptionDescriptor.unwrap(PasswordEncryptor.CONTEXT.createUnmarshaller().unmarshal((Node)keyDescriptor));
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Failed parsing password key encryptor", e);
        }
    }

    public static final CipherAlgorithm getAlgorithm(String str) {
        return XmlEncryptionDescriptor.parseEnum(str, CipherAlgorithm.class);
    }

    public static final CipherChaining getChaining(String str) {
        return XmlEncryptionDescriptor.parseEnum(str, CipherChaining.class);
    }

    public static final HashAlgorithm getHash(String str) {
        return XmlEncryptionDescriptor.parseEnum(str, HashAlgorithm.class);
    }

    public static final Digest initDigest(String str) {
        return XmlEncryptionDescriptor.getHash(str).initDigest();
    }

    public static final BlockCipher initCipher(String cipherStr, String chainStr) {
        return XmlEncryptionDescriptor.getChaining(chainStr).initChainingMode(XmlEncryptionDescriptor.getAlgorithm(cipherStr).initBlockCipher());
    }

    private static <E extends Enum<E>> E parseEnum(String str, Class<E> enumClazz) {
        String origStr = str;
        if ((str = str.trim().toUpperCase().replaceAll("[-_]", "")).length() > 0 && Character.isDigit(str.charAt(0))) {
            str = '_' + str;
        }
        try {
            return Enum.valueOf(enumClazz, str);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unsupported encryption parameter: " + origStr);
        }
    }

    private static Object unwrap(Object obj) {
        if (obj instanceof JAXBElement) {
            obj = ((JAXBElement)obj).getValue();
        }
        return obj;
    }

    private static <T> T newInstance(Class<? extends T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed initializing encryption algorithm: " + clazz.getSimpleName(), e);
        }
    }

    private static final JAXBContext loadContext(String name) {
        try {
            return JAXBContext.newInstance((String)name, (ClassLoader)XmlEncryptionDescriptor.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ JAXBContext access$000(String x0) {
        return XmlEncryptionDescriptor.loadContext(x0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HashAlgorithm {
        SHA1(SHA1Digest.class),
        SHA256(SHA256Digest.class),
        SHA512(SHA512Digest.class),
        MD5(MD5Digest.class),
        MD4(MD4Digest.class),
        MD2(MD2Digest.class),
        RIPEMD128(RIPEMD128Digest.class),
        RIPEMD160(RIPEMD160Digest.class),
        WHIRLPOOL(WhirlpoolDigest.class);

        private final Class<? extends Digest> _digestClazz;

        private HashAlgorithm(Class<? extends Digest> digestClazz) {
            this._digestClazz = digestClazz;
        }

        public Digest initDigest() {
            return (Digest)XmlEncryptionDescriptor.newInstance(this._digestClazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CipherChaining {
        CHAININGMODECBC{

            public BlockCipher initChainingMode(BlockCipher baseCipher) {
                return new CBCBlockCipher(baseCipher);
            }
        }
        ,
        CHAININGMODECFB{

            public BlockCipher initChainingMode(BlockCipher baseCipher) {
                return new CFBBlockCipher(baseCipher, 8);
            }
        };


        public abstract BlockCipher initChainingMode(BlockCipher var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CipherAlgorithm {
        AES(AESEngine.class),
        RC2(RC2Engine.class),
        DES(DESEngine.class),
        _3DES(DESedeEngine.class),
        _3DES112(DESedeEngine.class);

        private final Class<? extends BlockCipher> _blockCipherClazz;

        private CipherAlgorithm(Class<? extends BlockCipher> blockCipherClazz) {
            this._blockCipherClazz = blockCipherClazz;
        }

        public BlockCipher initBlockCipher() {
            return (BlockCipher)XmlEncryptionDescriptor.newInstance(this._blockCipherClazz);
        }
    }

    private static final class PasswordEncryptor {
        private static final JAXBContext CONTEXT = XmlEncryptionDescriptor.access$000("com.healthmarketscience.jackcess.cryptmodel.password");

        private PasswordEncryptor() {
        }
    }

    private static final class Encypt {
        private static final JAXBContext CONTEXT = XmlEncryptionDescriptor.access$000("com.healthmarketscience.jackcess.cryptmodel");

        private Encypt() {
        }
    }
}

