/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.office;

import com.healthmarketscience.jackcess.cryptmodel.CTEncryption;
import com.healthmarketscience.jackcess.cryptmodel.CTKeyData;
import com.healthmarketscience.jackcess.cryptmodel.CTKeyEncryptor;
import com.healthmarketscience.jackcess.cryptmodel.password.CTPasswordKeyEncryptor;
import com.healthmarketscience.jackcess.cryptmodel.password.STPasswordKeyEncryptorUri;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.office.BlockCipherProvider;
import com.healthmarketscience.jackcess.impl.office.XmlEncryptionDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AgileEncryptionProvider
extends BlockCipherProvider {
    private static final int RESERVED_VAL = 64;
    private static final byte[] ENC_VERIFIER_INPUT_BLOCK = new byte[]{-2, -89, -46, 118, 59, 75, -98, 121};
    private static final byte[] ENC_VERIFIER_VALUE_BLOCK = new byte[]{-41, -86, 15, 109, 48, 97, 52, 78};
    private static final byte[] ENC_VALUE_BLOCK = new byte[]{20, 110, 11, -25, -85, -84, -48, -42};
    private final CTEncryption _encryptDesc;
    private final CTPasswordKeyEncryptor _pwdKeyEnc;
    private final byte[] _keyValue;

    public AgileEncryptionProvider(PageChannel channel, byte[] encodingKey, ByteBuffer encProvBuf, byte[] pwdBytes) throws IOException {
        super(channel, encodingKey);
        if (encProvBuf.getInt() != 64) {
            throw new IllegalStateException("Unexpected reserved value");
        }
        byte[] xmlBytes = new byte[encProvBuf.remaining()];
        encProvBuf.get(xmlBytes);
        this._encryptDesc = XmlEncryptionDescriptor.parseEncryptionDescriptor(xmlBytes);
        CTPasswordKeyEncryptor pwdKeyEnc = null;
        if (this._encryptDesc.getKeyEncryptors() != null && this._encryptDesc.getKeyEncryptors().getKeyEncryptor().size() == 1) {
            CTKeyEncryptor keyEnc = this._encryptDesc.getKeyEncryptors().getKeyEncryptor().get(0);
            if (STPasswordKeyEncryptorUri.HTTP_SCHEMAS_MICROSOFT_COM_OFFICE_2006_KEY_ENCRYPTOR_PASSWORD.value().equals(keyEnc.getUri())) {
                pwdKeyEnc = XmlEncryptionDescriptor.parsePasswordKeyEncryptor(keyEnc.getAny());
            }
        }
        if (pwdKeyEnc == null) {
            throw new IllegalStateException("Missing or unexpected key encryptor");
        }
        this._pwdKeyEnc = pwdKeyEnc;
        this._keyValue = this.decryptKeyValue(pwdBytes);
    }

    protected Digest initPwdDigest() {
        return XmlEncryptionDescriptor.initDigest(this._pwdKeyEnc.getHashAlgorithm());
    }

    protected Digest initCryptDigest() {
        return XmlEncryptionDescriptor.initDigest(this._encryptDesc.getKeyData().getHashAlgorithm());
    }

    protected BlockCipher initPwdCipher() {
        return XmlEncryptionDescriptor.initCipher(this._pwdKeyEnc.getCipherAlgorithm(), this._pwdKeyEnc.getCipherChaining());
    }

    protected BlockCipher initCryptCipher() {
        CTKeyData keyData = this._encryptDesc.getKeyData();
        return XmlEncryptionDescriptor.initCipher(keyData.getCipherAlgorithm(), keyData.getCipherChaining());
    }

    protected boolean verifyPassword(byte[] pwdBytes) {
        byte[] verifier = this.decryptVerifierHashInput(pwdBytes);
        byte[] verifierHash = this.decryptVerifierHashValue(pwdBytes);
        byte[] testHash = AgileEncryptionProvider.hash(this.getDigest(), verifier);
        if ((long)testHash.length / this._pwdKeyEnc.getBlockSize() != 0L) {
            int hashLen = (testHash.length / (int)this._pwdKeyEnc.getBlockSize() + 1) * (int)this._pwdKeyEnc.getBlockSize();
            testHash = AgileEncryptionProvider.fixToLength(testHash, hashLen);
        }
        return Arrays.equals(verifierHash, testHash);
    }

    protected ParametersWithIV computeCipherParams(int pageNumber) {
        byte[] blockBytes = this.getEncodingKey(pageNumber);
        CTKeyData keyData = this._encryptDesc.getKeyData();
        byte[] iv = this.cryptDeriveIV(blockBytes, keyData.getSaltValue(), (int)keyData.getBlockSize());
        return new ParametersWithIV((CipherParameters)new KeyParameter(this._keyValue), iv);
    }

    private byte[] decryptVerifierHashInput(byte[] pwdBytes) {
        byte[] key = this.cryptDeriveKey(pwdBytes, ENC_VERIFIER_INPUT_BLOCK, this._pwdKeyEnc.getSaltValue(), (int)this._pwdKeyEnc.getSpinCount(), AgileEncryptionProvider.bits2bytes((int)this._pwdKeyEnc.getKeyBits()));
        return this.blockDecryptBytes(key, this._pwdKeyEnc.getSaltValue(), this._pwdKeyEnc.getEncryptedVerifierHashInput());
    }

    private byte[] decryptVerifierHashValue(byte[] pwdBytes) {
        byte[] key = this.cryptDeriveKey(pwdBytes, ENC_VERIFIER_VALUE_BLOCK, this._pwdKeyEnc.getSaltValue(), (int)this._pwdKeyEnc.getSpinCount(), AgileEncryptionProvider.bits2bytes((int)this._pwdKeyEnc.getKeyBits()));
        return this.blockDecryptBytes(key, this._pwdKeyEnc.getSaltValue(), this._pwdKeyEnc.getEncryptedVerifierHashValue());
    }

    private byte[] decryptKeyValue(byte[] pwdBytes) {
        byte[] key = this.cryptDeriveKey(pwdBytes, ENC_VALUE_BLOCK, this._pwdKeyEnc.getSaltValue(), (int)this._pwdKeyEnc.getSpinCount(), AgileEncryptionProvider.bits2bytes((int)this._pwdKeyEnc.getKeyBits()));
        return this.blockDecryptBytes(key, this._pwdKeyEnc.getSaltValue(), this._pwdKeyEnc.getEncryptedKeyValue());
    }

    private byte[] cryptDeriveKey(byte[] pwdBytes, byte[] blockBytes, byte[] salt, int iterations, int keyByteLen) {
        Digest digest = this.getDigest();
        byte[] baseHash = AgileEncryptionProvider.hash(digest, salt, pwdBytes);
        byte[] iterHash = this.iterateHash(baseHash, iterations);
        byte[] finalHash = AgileEncryptionProvider.hash(digest, iterHash, blockBytes);
        return AgileEncryptionProvider.fixToLength(finalHash, keyByteLen, 54);
    }

    private byte[] cryptDeriveIV(byte[] blockBytes, byte[] salt, int keyByteLen) {
        byte[] ivBytes = blockBytes != null ? AgileEncryptionProvider.hash(this.getDigest(), salt, blockBytes) : salt;
        return AgileEncryptionProvider.fixToLength(ivBytes, keyByteLen, 54);
    }
}

