/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.BaseCryptCodecHandler;
import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.CodecHandler;
import com.healthmarketscience.jackcess.DefaultCodecProvider;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bouncycastle.crypto.params.KeyParameter;

public class JetCryptCodecHandler
extends BaseCryptCodecHandler {
    static final int ENCODING_KEY_LENGTH = 4;
    private final byte[] _encodingKey;

    JetCryptCodecHandler(PageChannel channel, byte[] encodingKey) {
        super(channel);
        this._encodingKey = encodingKey;
    }

    public static CodecHandler create(PageChannel channel) throws IOException {
        ByteBuffer buffer = JetCryptCodecHandler.readHeaderPage(channel);
        JetFormat format = channel.getFormat();
        byte[] encodingKey = ByteUtil.getBytes((ByteBuffer)buffer, (int)format.OFFSET_ENCODING_KEY, (int)4);
        return JetCryptCodecHandler.isBlankKey(encodingKey) ? DefaultCodecProvider.DUMMY_HANDLER : new JetCryptCodecHandler(channel, encodingKey);
    }

    public boolean canEncodePartialPage() {
        return true;
    }

    public void decodePage(ByteBuffer buffer, int pageNumber) {
        if (!this.isEncryptedPage(pageNumber)) {
            return;
        }
        byte[] key = JetCryptCodecHandler.applyPageNumber(this._encodingKey, 0, pageNumber);
        this.decodePage(buffer, new KeyParameter(key));
    }

    public ByteBuffer encodePage(ByteBuffer buffer, int pageNumber, int pageOffset) {
        if (!this.isEncryptedPage(pageNumber)) {
            return buffer;
        }
        byte[] key = JetCryptCodecHandler.applyPageNumber(this._encodingKey, 0, pageNumber);
        return this.encodePage(buffer, pageOffset, new KeyParameter(key));
    }

    protected int getMaxEncodedPage() {
        return Integer.MAX_VALUE;
    }

    private boolean isEncryptedPage(int pageNumber) {
        return pageNumber > 0 && pageNumber <= this.getMaxEncodedPage();
    }
}

