/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.CodecHandler;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.TempBufferHolder;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;

public abstract class BaseCryptCodecHandler
implements CodecHandler {
    public static final boolean CIPHER_DECRYPT_MODE = false;
    public static final boolean CIPHER_ENCRYPT_MODE = true;
    private final PageChannel _channel;
    private RC4Engine _engine;
    private TempBufferHolder _encodeBuf;

    protected BaseCryptCodecHandler(PageChannel channel) {
        this._channel = channel;
    }

    protected final RC4Engine getEngine() {
        if (this._engine == null) {
            this._engine = new RC4Engine();
        }
        return this._engine;
    }

    protected ByteBuffer getTempEncodeBuffer() {
        if (this._encodeBuf == null) {
            this._encodeBuf = TempBufferHolder.newHolder((TempBufferHolder.Type)TempBufferHolder.Type.SOFT, (boolean)true);
        }
        return this._encodeBuf.getPageBuffer(this._channel);
    }

    protected void decodePage(ByteBuffer buffer, KeyParameter params) {
        RC4Engine engine = this.getEngine();
        engine.init(false, (CipherParameters)params);
        byte[] array = buffer.array();
        engine.processBytes(array, 0, array.length, array, 0);
    }

    public ByteBuffer encodePage(ByteBuffer buffer, int pageNumber, int pageOffset) {
        throw new UnsupportedOperationException("Encryption is currently not supported");
    }

    protected ByteBuffer encodePage(ByteBuffer buffer, int pageOffset, KeyParameter params) {
        RC4Engine engine = this.getEngine();
        engine.init(true, (CipherParameters)params);
        int limit = buffer.limit();
        ByteBuffer encodeBuf = this.getTempEncodeBuffer();
        encodeBuf.clear();
        byte[] inArray = buffer.array();
        engine.processBytes(inArray, 0, limit, encodeBuf.array(), 0);
        return encodeBuf;
    }

    protected static ByteBuffer readHeaderPage(PageChannel pageChannel) throws IOException {
        ByteBuffer buffer = pageChannel.createPageBuffer();
        pageChannel.readPage(buffer, 0);
        return buffer;
    }

    public static byte[] applyPageNumber(byte[] key, int offset, int pageNumber) {
        byte[] tmp = ByteUtil.copyOf((byte[])key, (int)key.length);
        ByteBuffer bb = BaseCryptCodecHandler.wrap(tmp);
        bb.position(offset);
        bb.putInt(pageNumber);
        for (int i = offset; i < offset + 4; ++i) {
            int n = i;
            tmp[n] = (byte)(tmp[n] ^ key[i]);
        }
        return tmp;
    }

    public static byte[] hash(Digest digest, byte[] bytes) {
        return BaseCryptCodecHandler.hash(digest, bytes, null, 0);
    }

    public static byte[] hash(Digest digest, byte[] bytes1, byte[] bytes2) {
        return BaseCryptCodecHandler.hash(digest, bytes1, bytes2, 0);
    }

    public static byte[] hash(Digest digest, byte[] bytes, int resultLen) {
        return BaseCryptCodecHandler.hash(digest, bytes, null, resultLen);
    }

    public static byte[] hash(Digest digest, byte[] bytes1, byte[] bytes2, int resultLen) {
        digest.reset();
        digest.update(bytes1, 0, bytes1.length);
        if (bytes2 != null) {
            digest.update(bytes2, 0, bytes2.length);
        }
        byte[] digestBytes = new byte[digest.getDigestSize()];
        digest.doFinal(digestBytes, 0);
        if (resultLen > 0) {
            digestBytes = BaseCryptCodecHandler.fixToLength(digestBytes, resultLen);
        }
        return digestBytes;
    }

    public static byte[] fixToLength(byte[] bytes, int len) {
        if (bytes.length != len) {
            bytes = ByteUtil.copyOf((byte[])bytes, (int)len);
        }
        return bytes;
    }

    public static ByteBuffer wrap(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(PageChannel.DEFAULT_BYTE_ORDER);
    }

    protected static boolean isBlankKey(byte[] key) {
        for (byte byteVal : key) {
            if (byteVal == 0) continue;
            return false;
        }
        return true;
    }
}

