/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.BaseCryptCodecHandler;
import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.CodecHandler;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.JetCryptCodecHandler;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;

public class MSISAMCryptCodecHandler
extends BaseCryptCodecHandler {
    private static final int SALT_OFFSET = 114;
    private static final int CRYPT_CHECK_START = 745;
    private static final int ENCRYPTION_FLAGS_OFFSET = 664;
    private static final int SALT_LENGTH = 4;
    private static final int PASSWORD_LENGTH = 40;
    private static final int USE_SHA1 = 32;
    private static final int PASSWORD_DIGEST_LENGTH = 16;
    private static final int MSISAM_MAX_ENCRYPTED_PAGE = 14;
    private static final int NEW_ENCRYPTION = 6;
    private static final int TRAILING_PWD_LEN = 20;
    private final byte[] _encodingKey;

    MSISAMCryptCodecHandler(PageChannel channel, String password, Charset charset, ByteBuffer buffer) throws IOException {
        super(channel);
        byte[] salt = new byte[8];
        buffer.position(114);
        buffer.get(salt);
        byte[] pwdDigest = MSISAMCryptCodecHandler.createPasswordDigest(buffer, password, charset);
        byte[] baseSalt = Arrays.copyOf(salt, 4);
        this.verifyPassword(buffer, MSISAMCryptCodecHandler.concat(pwdDigest, salt), baseSalt);
        this._encodingKey = MSISAMCryptCodecHandler.concat(pwdDigest, baseSalt);
    }

    public static CodecHandler create(String password, PageChannel channel, Charset charset) throws IOException {
        ByteBuffer buffer = MSISAMCryptCodecHandler.readHeaderPage(channel);
        if ((buffer.get(664) & 6) != 0) {
            return new MSISAMCryptCodecHandler(channel, password, charset, buffer);
        }
        return new JetCryptCodecHandler(channel, MSISAMCryptCodecHandler.getOldDecryptionKey(buffer, channel.getFormat())){

            protected int getMaxEncodedPage() {
                return 14;
            }
        };
    }

    public void decodePage(ByteBuffer buffer, int pageNumber) {
        if (!this.isEncryptedPage(pageNumber)) {
            return;
        }
        byte[] key = MSISAMCryptCodecHandler.applyPageNumber(this._encodingKey, 16, pageNumber);
        this.decodePage(buffer, new KeyParameter(key));
    }

    public ByteBuffer encodePage(ByteBuffer buffer, int pageNumber, int pageOffset) {
        if (!this.isEncryptedPage(pageNumber)) {
            return buffer;
        }
        byte[] key = MSISAMCryptCodecHandler.applyPageNumber(this._encodingKey, 16, pageNumber);
        return this.encodePage(buffer, new KeyParameter(key));
    }

    private boolean isEncryptedPage(int pageNumber) {
        return pageNumber > 0 && pageNumber <= 14;
    }

    private void verifyPassword(ByteBuffer buffer, byte[] testEncodingKey, byte[] testBytes) {
        RC4Engine engine = this.getEngine();
        engine.init(false, (CipherParameters)new KeyParameter(testEncodingKey));
        byte[] encrypted4BytesCheck = MSISAMCryptCodecHandler.getPasswordTestBytes(buffer);
        if (MSISAMCryptCodecHandler.isBlankKey(encrypted4BytesCheck)) {
            return;
        }
        byte[] decrypted4BytesCheck = new byte[4];
        engine.processBytes(encrypted4BytesCheck, 0, encrypted4BytesCheck.length, decrypted4BytesCheck, 0);
        if (!Arrays.equals(decrypted4BytesCheck, testBytes)) {
            throw new IllegalStateException("Incorrect password provided");
        }
    }

    private static byte[] createPasswordDigest(ByteBuffer buffer, String password, Charset charset) {
        SHA1Digest digest = (buffer.get(664) & 0x20) != 0 ? new SHA1Digest() : new MD5Digest();
        byte[] passwordBytes = new byte[40];
        if (password != null) {
            ByteBuffer bb = Column.encodeUncompressedText((CharSequence)password.toUpperCase(), (Charset)charset);
            bb.get(passwordBytes, 0, Math.min(passwordBytes.length, bb.remaining()));
        }
        digest.update(passwordBytes, 0, passwordBytes.length);
        byte[] digestBytes = new byte[digest.getDigestSize()];
        digest.doFinal(digestBytes, 0);
        if (digestBytes.length != 16) {
            digestBytes = ByteUtil.copyOf((byte[])digestBytes, (int)16);
        }
        return digestBytes;
    }

    private static byte[] getOldDecryptionKey(ByteBuffer buffer, JetFormat format) {
        byte[] encodingKey = new byte[4];
        buffer.position(114);
        buffer.get(encodingKey);
        byte[] fullHashData = new byte[format.SIZE_PASSWORD * 2];
        buffer.position(format.OFFSET_PASSWORD);
        buffer.get(fullHashData);
        byte[] pwdMask = Database.getPasswordMask((ByteBuffer)buffer, (JetFormat)format);
        if (pwdMask != null) {
            for (int i = 0; i < format.SIZE_PASSWORD; ++i) {
                int n = i;
                fullHashData[n] = (byte)(fullHashData[n] ^ pwdMask[i % pwdMask.length]);
            }
            int trailingOffset = fullHashData.length - 20;
            for (int i = 0; i < 20; ++i) {
                int n = trailingOffset + i;
                fullHashData[n] = (byte)(fullHashData[n] ^ pwdMask[i % pwdMask.length]);
            }
        }
        byte[] hashData = new byte[format.SIZE_PASSWORD];
        for (int pos = 0; pos < format.SIZE_PASSWORD; ++pos) {
            hashData[pos] = fullHashData[pos * 2];
        }
        MSISAMCryptCodecHandler.hashSalt(encodingKey, hashData);
        byte[] jetHeader = new byte[15];
        buffer.position(4);
        buffer.get(jetHeader);
        MSISAMCryptCodecHandler.hashSalt(encodingKey, jetHeader);
        return encodingKey;
    }

    private static byte[] getPasswordTestBytes(ByteBuffer buffer) {
        byte[] encrypted4BytesCheck = new byte[4];
        int cryptCheckOffset = ByteUtil.getUnsignedByte((ByteBuffer)buffer, (int)114);
        buffer.position(745 + cryptCheckOffset);
        buffer.get(encrypted4BytesCheck);
        return encrypted4BytesCheck;
    }

    private static byte[] concat(byte[] b1, byte[] b2) {
        byte[] out = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, out, 0, b1.length);
        System.arraycopy(b2, 0, out, b1.length, b2.length);
        return out;
    }

    private static void hashSalt(byte[] salt, byte[] hashData) {
        ByteBuffer bb = ByteBuffer.wrap(salt).order(PageChannel.DEFAULT_BYTE_ORDER);
        int hash = bb.getInt();
        for (int pos = 0; pos < hashData.length; ++pos) {
            int tmp = hashData[pos] & 0xFF;
            hash ^= (tmp <<= pos % 24);
        }
        bb.rewind();
        bb.putInt(hash);
    }
}

