/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.common.util;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendableExtWrapper
implements AppendableExt {
    private final Appendable _app;
    private IOException _ioException;
    private Object _context;

    public AppendableExtWrapper() {
        this._app = new StringBuilder();
    }

    public AppendableExtWrapper(int capacity) {
        this(capacity, null);
    }

    public AppendableExtWrapper(int size, Object context) {
        this._app = new StringBuilder(size);
        this._context = context;
    }

    public AppendableExtWrapper(Appendable app) {
        this._app = app;
    }

    @Override
    public AppendableExtWrapper append(char c) {
        try {
            this._app.append(c);
        }
        catch (IOException e) {
            this._ioException = e;
        }
        return this;
    }

    @Override
    public AppendableExtWrapper append(CharSequence s) {
        if (s instanceof Appendee) {
            return this.append((Appendee)((Object)s));
        }
        try {
            this._app.append(s);
        }
        catch (IOException e) {
            this._ioException = e;
        }
        return this;
    }

    @Override
    public AppendableExtWrapper append(CharSequence s, int start, int end) {
        try {
            this._app.append(s, start, end);
        }
        catch (IOException e) {
            this._ioException = e;
        }
        return this;
    }

    @Override
    public AppendableExtWrapper append(Appendee a) {
        try {
            a.appendTo(this);
        }
        catch (IOException e) {
            this._ioException = e;
        }
        return this;
    }

    @Override
    public AppendableExtWrapper append(Object o) {
        if (o instanceof Appendee) {
            return this.append((Appendee)o);
        }
        if (o instanceof CharSequence) {
            return this.append((CharSequence)o);
        }
        try {
            this._app.append(String.valueOf(o));
        }
        catch (IOException e) {
            this._ioException = e;
        }
        return this;
    }

    @Override
    public AppendableExtWrapper append(Iterable<?> iable, Object delimiter) {
        Iterator<?> iter = iable.iterator();
        while (iter.hasNext()) {
            this.append(iter.next());
            if (!iter.hasNext()) continue;
            this.append(delimiter);
        }
        return this;
    }

    public Appendable getAppendable() {
        return this._app;
    }

    public IOException getIOException() {
        return this._ioException;
    }

    public String toString() {
        return this._app.toString();
    }

    @Override
    public Object getContext() {
        return this._context;
    }

    @Override
    public void setContext(Object newContext) {
        this._context = newContext;
    }
}

