/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.map.impl.record.AbstractRecord;
import com.hazelcast.map.impl.record.RecordReaderWriter;

abstract class AbstractRecordWithStats<V>
extends AbstractRecord<V> {
    private int lastStoredTime = -1;
    private int expirationTime = -1;

    AbstractRecordWithStats() {
    }

    @Override
    public long getCost() {
        int numberOfIntFields = 2;
        return super.getCost() + 8L;
    }

    @Override
    public long getExpirationTime() {
        if (this.expirationTime == -1) {
            return 0L;
        }
        if (this.expirationTime == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.recomputeWithBaseTime(this.expirationTime);
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime == Long.MAX_VALUE ? Integer.MAX_VALUE : this.stripBaseTime(expirationTime);
    }

    @Override
    public long getLastStoredTime() {
        if (this.lastStoredTime == -1) {
            return 0L;
        }
        return this.recomputeWithBaseTime(this.lastStoredTime);
    }

    @Override
    public void setLastStoredTime(long lastStoredTime) {
        this.lastStoredTime = this.stripBaseTime(lastStoredTime);
    }

    @Override
    public int getRawLastStoredTime() {
        return this.lastStoredTime;
    }

    @Override
    public void setRawLastStoredTime(int time) {
        this.lastStoredTime = time;
    }

    @Override
    public int getRawExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setRawExpirationTime(int time) {
        this.expirationTime = time;
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.DATA_RECORD_WITH_STATS_READER_WRITER;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractRecordWithStats that = (AbstractRecordWithStats)o;
        if (this.lastStoredTime != that.lastStoredTime) {
            return false;
        }
        return this.expirationTime == that.expirationTime;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.lastStoredTime;
        result = 31 * result + this.expirationTime;
        return result;
    }

    @Override
    public String toString() {
        return "AbstractRecordWithStats{lastStoredTime=" + this.lastStoredTime + ", expirationTime=" + this.expirationTime + "} " + super.toString();
    }
}

