/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.ConstantFunctionEx;
import javax.annotation.Nonnull;

public class GlobalFlatMapStatefulTransform<T, S, R>
extends AbstractTransform {
    private final ToLongFunctionEx<? super T> timestampFn;
    private final SupplierEx<? extends S> createFn;
    private final TriFunction<? super S, Object, ? super T, ? extends Traverser<R>> statefulFlatMapFn;

    public GlobalFlatMapStatefulTransform(@Nonnull Transform upstream, @Nonnull ToLongFunctionEx<? super T> timestampFn, @Nonnull SupplierEx<? extends S> createFn, @Nonnull TriFunction<? super S, Object, ? super T, ? extends Traverser<R>> statefulFlatMapFn) {
        super("flatmap-stateful-global", upstream);
        this.timestampFn = timestampFn;
        this.createFn = createFn;
        this.statefulFlatMapFn = statefulFlatMapFn;
    }

    @Override
    public void addToDag(Planner p) {
        ConstantFunctionEx keyFn = new ConstantFunctionEx(this.name().hashCode());
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), 1, Processors.flatMapStatefulP(Long.MAX_VALUE, keyFn, this.timestampFn, this.createFn, this.statefulFlatMapFn, null));
        p.addEdges((Transform)this, pv.v, edge -> edge.partitioned(keyFn).distributed());
    }
}

