/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.Sink;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SinkImpl<T>
implements Sink<T> {
    private final String name;
    private final ProcessorMetaSupplier metaSupplier;
    private boolean assignedToStage;
    private final Type type;
    private final FunctionEx<? super T, ?> partitionKeyFunction;

    public SinkImpl(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier) {
        this(name, metaSupplier, Type.DEFAULT, null);
    }

    public SinkImpl(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier, @Nullable FunctionEx<? super T, ?> partitionKeyFn) {
        this(name, metaSupplier, Type.PARTITIONED, partitionKeyFn);
    }

    public SinkImpl(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier, @Nonnull Type type) {
        this(name, metaSupplier, type, null);
    }

    public SinkImpl(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier, @Nonnull Type type, @Nullable FunctionEx<? super T, ?> partitionKeyFn) {
        if (type.isPartitioned() && partitionKeyFn == null) {
            throw new IllegalArgumentException("Partitioned type " + (Object)((Object)type) + " needs a partition key function");
        }
        if (!type.isPartitioned() && partitionKeyFn != null) {
            throw new IllegalArgumentException("Non partitioned type " + (Object)((Object)type) + " can't have a partition key function");
        }
        this.name = name;
        this.metaSupplier = metaSupplier;
        this.type = type;
        this.partitionKeyFunction = partitionKeyFn;
    }

    @Nonnull
    public ProcessorMetaSupplier metaSupplier() {
        return this.metaSupplier;
    }

    @Override
    public String name() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public FunctionEx<? super T, ?> partitionKeyFunction() {
        return this.partitionKeyFunction;
    }

    void onAssignToStage() {
        if (this.assignedToStage) {
            throw new IllegalStateException("Sink " + this.name + " was already assigned to a sink stage");
        }
        this.assignedToStage = true;
    }

    public static enum Type {
        DEFAULT(false, false),
        PARTITIONED(true, false),
        DISTRIBUTED_PARTITIONED(true, true),
        TOTAL_PARALLELISM_ONE(false, true);

        boolean partitioned;
        boolean distributed;

        private Type(boolean partitioned, boolean distributed) {
            this.partitioned = partitioned;
            this.distributed = distributed;
        }

        public boolean isPartitioned() {
            return this.partitioned;
        }

        public boolean isDistributed() {
            return this.distributed;
        }
    }
}

