/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.lock;

import com.hazelcast.cp.internal.datastructures.lock.LockInvocationKey;
import com.hazelcast.cp.internal.datastructures.lock.LockOwnershipState;
import java.util.Collection;
import java.util.Collections;

class ReleaseResult {
    static final ReleaseResult FAILED = new ReleaseResult(false, LockOwnershipState.NOT_LOCKED, Collections.emptyList());
    private final boolean success;
    private final LockOwnershipState ownership;
    private final Collection<LockInvocationKey> completedWaitKeys;

    ReleaseResult(boolean success, LockOwnershipState ownership, Collection<LockInvocationKey> completedWaitKeys) {
        this.success = success;
        this.ownership = ownership;
        this.completedWaitKeys = Collections.unmodifiableCollection(completedWaitKeys);
    }

    static ReleaseResult successful(LockOwnershipState ownership) {
        return new ReleaseResult(true, ownership, Collections.emptyList());
    }

    static ReleaseResult successful(LockOwnershipState ownership, Collection<LockInvocationKey> notifications) {
        return new ReleaseResult(true, ownership, notifications);
    }

    static ReleaseResult failed(Collection<LockInvocationKey> notifications) {
        return new ReleaseResult(false, LockOwnershipState.NOT_LOCKED, notifications);
    }

    public boolean success() {
        return this.success;
    }

    public LockOwnershipState ownership() {
        return this.ownership;
    }

    Collection<LockInvocationKey> completedWaitKeys() {
        return this.completedWaitKeys;
    }
}

