/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.jet.impl.operation.AbstractJobOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import java.io.IOException;
import javax.annotation.Nullable;

public class TerminateExecutionOperation
extends AbstractJobOperation {
    private long executionId;
    private TerminationMode mode;

    public TerminateExecutionOperation() {
    }

    public TerminateExecutionOperation(long jobId, long executionId, @Nullable TerminationMode mode) {
        super(jobId);
        this.executionId = executionId;
        this.mode = mode;
    }

    @Override
    public void run() {
        JetService service = (JetService)this.getService();
        JobExecutionService executionService = service.getJobExecutionService();
        Address callerAddress = this.getCallerAddress();
        ExecutionContext ctx = executionService.assertExecutionContext(callerAddress, this.jobId(), this.executionId, this.getClass().getSimpleName());
        ctx.terminateExecution(this.mode);
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isRestartableException(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeByte(this.mode != null ? this.mode.ordinal() : -1);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        byte modeOrdinal = in.readByte();
        this.mode = modeOrdinal < 0 ? null : TerminationMode.values()[modeOrdinal];
    }
}

