/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class SubmitJobOperation
extends AsyncJobOperation {
    private Data dag;
    private Data config;

    public SubmitJobOperation() {
    }

    public SubmitJobOperation(long jobId, Data dag, Data config) {
        super(jobId);
        this.dag = dag;
        this.config = config;
    }

    public CompletableFuture<Void> doRun() {
        return this.getJobCoordinationService().submitJob(this.jobId(), this.dag, this.config);
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeData(out, this.dag);
        IOUtil.writeData(out, this.config);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.dag = IOUtil.readData(in);
        this.config = IOUtil.readData(in);
    }
}

