/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics;

import com.hazelcast.jet.core.metrics.Metric;
import com.hazelcast.jet.core.metrics.Unit;
import com.hazelcast.jet.impl.metrics.MetricsContext;
import javax.annotation.Nullable;

public final class MetricsImpl {
    private static final ThreadLocal<Container> CONTEXT = ThreadLocal.withInitial(Container::new);

    private MetricsImpl() {
    }

    public static Container container() {
        return CONTEXT.get();
    }

    public static Metric metric(String name, Unit unit) {
        return MetricsImpl.getContext().metric(name, unit);
    }

    public static Metric threadSafeMetric(String name, Unit unit) {
        return MetricsImpl.getContext().threadSafeMetric(name, unit);
    }

    private static MetricsContext getContext() {
        Container container = CONTEXT.get();
        MetricsContext context = container.getContext();
        if (context == null) {
            throw new RuntimeException("Thread %s has no metrics context set, this method can be called only on threads executing the job's processors");
        }
        return context;
    }

    public static class Container {
        @Nullable
        private MetricsContext context;

        Container() {
        }

        @Nullable
        public MetricsContext getContext() {
            return this.context;
        }

        public void setContext(@Nullable MetricsContext context) {
            this.context = context;
        }
    }
}

