/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.com.fasterxml.jackson.jr.ob.impl;

import com.hazelcast.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.com.fasterxml.jackson.core.JsonToken;
import com.hazelcast.com.fasterxml.jackson.jr.ob.JSON;
import com.hazelcast.com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.hazelcast.com.fasterxml.jackson.jr.ob.api.CollectionBuilder;
import com.hazelcast.com.fasterxml.jackson.jr.ob.api.MapBuilder;
import com.hazelcast.com.fasterxml.jackson.jr.ob.api.ValueReader;
import com.hazelcast.com.fasterxml.jackson.jr.ob.impl.JSONReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class AnyReader
extends ValueReader {
    public static final AnyReader std = new AnyReader();

    public AnyReader() {
        super(Object.class);
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        jsonParser.nextToken();
        return this.read(jSONReader, jsonParser);
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 11: {
                return null;
            }
            case 1: {
                return this.readFromObject(jSONReader, jsonParser, jSONReader._mapBuilder);
            }
            case 3: {
                if (jSONReader.arraysAsLists()) {
                    return this.readCollectionFromArray(jSONReader, jsonParser, jSONReader._collectionBuilder);
                }
                return this.readArrayFromArray(jSONReader, jsonParser, jSONReader._collectionBuilder);
            }
            case 6: {
                return this.fromString(jsonParser.getText());
            }
            case 7: {
                JsonParser.NumberType numberType = jsonParser.getNumberType();
                if (numberType == JsonParser.NumberType.INT) {
                    return jsonParser.getIntValue();
                }
                if (numberType == JsonParser.NumberType.LONG) {
                    return jsonParser.getLongValue();
                }
                return jsonParser.getBigIntegerValue();
            }
            case 8: {
                if (!JSON.Feature.USE_BIG_DECIMAL_FOR_FLOATS.isEnabled(jSONReader._features)) {
                    JsonParser.NumberType numberType = jsonParser.getNumberType();
                    if (numberType == JsonParser.NumberType.FLOAT) {
                        return Float.valueOf(jsonParser.getFloatValue());
                    }
                    if (numberType == JsonParser.NumberType.DOUBLE) {
                        return jsonParser.getDoubleValue();
                    }
                }
                return jsonParser.getDecimalValue();
            }
            case 9: {
                return this.fromBoolean(true);
            }
            case 10: {
                return this.fromBoolean(false);
            }
            case 12: {
                return this.fromEmbedded(jsonParser.getEmbeddedObject());
            }
        }
        throw JSONObjectException.from(jsonParser, "Unexpected value token: " + AnyReader._tokenDesc(jsonParser));
    }

    public Map<String, Object> readFromObject(JSONReader jSONReader, JsonParser jsonParser, MapBuilder mapBuilder) throws IOException {
        if (jsonParser.nextValue() == JsonToken.END_OBJECT) {
            return mapBuilder.emptyMap();
        }
        String string = this.fromKey(jsonParser.getCurrentName());
        Object object = this.read(jSONReader, jsonParser);
        if (jsonParser.nextValue() == JsonToken.END_OBJECT) {
            return mapBuilder.singletonMap(string, object);
        }
        try {
            mapBuilder = mapBuilder.start().put(string, object);
            do {
                mapBuilder = mapBuilder.put(this.fromKey(jsonParser.getCurrentName()), this.read(jSONReader, jsonParser));
            } while (jsonParser.nextValue() != JsonToken.END_OBJECT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JSONObjectException.from(jsonParser, illegalArgumentException.getMessage());
        }
        return mapBuilder.build();
    }

    public Object[] readArrayFromArray(JSONReader jSONReader, JsonParser jsonParser, CollectionBuilder collectionBuilder) throws IOException {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyArray();
        }
        Object object = this.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonArray(object);
        }
        try {
            collectionBuilder = collectionBuilder.start().add(object);
            do {
                collectionBuilder = collectionBuilder.add(this.read(jSONReader, jsonParser));
            } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
            return collectionBuilder.buildArray();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JSONObjectException.from(jsonParser, illegalArgumentException.getMessage());
        }
    }

    public Collection<Object> readCollectionFromArray(JSONReader jSONReader, JsonParser jsonParser, CollectionBuilder collectionBuilder) throws IOException {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyCollection();
        }
        Object object = this.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonCollection(object);
        }
        try {
            collectionBuilder = collectionBuilder.start().add(object);
            do {
                collectionBuilder = collectionBuilder.add(this.read(jSONReader, jsonParser));
            } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
            return collectionBuilder.buildCollection();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JSONObjectException.from(jsonParser, illegalArgumentException.getMessage());
        }
    }

    protected Object fromNull() throws IOException {
        return null;
    }

    protected Object fromBoolean(boolean bl) throws IOException {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String fromKey(String string) throws IOException {
        return string;
    }

    protected Object fromString(String string) throws IOException {
        return string;
    }

    protected Object fromEmbedded(Object object) throws IOException {
        return object;
    }
}

