/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.HeapData;

public final class DataCodec {
    private DataCodec() {
    }

    public static void encode(ClientMessage clientMessage, Data data) {
        clientMessage.add(new ClientMessage.Frame(data.toByteArray()));
    }

    public static void encodeNullable(ClientMessage clientMessage, Data data) {
        if (data == null) {
            clientMessage.add(ClientMessage.NULL_FRAME.copy());
        } else {
            clientMessage.add(new ClientMessage.Frame(data.toByteArray()));
        }
    }

    public static Data decode(ClientMessage.Frame frame) {
        return new HeapData(frame.content);
    }

    public static Data decode(ClientMessage.ForwardFrameIterator iterator) {
        return DataCodec.decode(iterator.next());
    }

    public static Data decodeNullable(ClientMessage.ForwardFrameIterator iterator) {
        return CodecUtil.nextFrameIsNullEndFrame(iterator) ? null : DataCodec.decode(iterator.next());
    }
}

