/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class MultiMapLockCodec {
    public static final int REQUEST_MESSAGE_TYPE = 135168;
    public static final int RESPONSE_MESSAGE_TYPE = 135169;
    private static final int REQUEST_THREAD_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_TTL_FIELD_OFFSET = 24;
    private static final int REQUEST_REFERENCE_ID_FIELD_OFFSET = 32;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 40;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private MultiMapLockCodec() {
    }

    public static ClientMessage encodeRequest(String name, Data key, long threadId, long ttl, long referenceId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("MultiMap.Lock");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[40], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 135168);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, threadId);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, ttl);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 32, referenceId);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, key);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.threadId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.ttl = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        request.referenceId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 32);
        request.name = StringCodec.decode(iterator);
        request.key = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 135169);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public Data key;
        public long threadId;
        public long ttl;
        public long referenceId;
    }
}

