/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.datamodel.KeyedWindowResult;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.pipeline.JetEventFunctionAdapter;
import com.hazelcast.jet.impl.pipeline.StageWithGroupingBase;
import com.hazelcast.jet.impl.pipeline.StreamStageImpl;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.pipeline.transform.WindowGroupTransform;
import com.hazelcast.jet.pipeline.StageWithKeyAndWindow;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.jet.pipeline.StreamStageWithKey;
import com.hazelcast.jet.pipeline.WindowDefinition;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;

public class StageWithKeyAndWindowImpl<T, K>
extends StageWithGroupingBase<T, K>
implements StageWithKeyAndWindow<T, K> {
    @Nonnull
    private final WindowDefinition wDef;

    StageWithKeyAndWindowImpl(@Nonnull StreamStageImpl<T> computeStage, @Nonnull FunctionEx<? super T, ? extends K> keyFn, @Nonnull WindowDefinition wDef) {
        super(computeStage, keyFn);
        this.wDef = wDef;
    }

    @Override
    @Nonnull
    public WindowDefinition windowDefinition() {
        return this.wDef;
    }

    @Override
    @Nonnull
    public <R> StreamStage<KeyedWindowResult<K, R>> aggregate(@Nonnull AggregateOperation1<? super T, ?, ? extends R> aggrOp) {
        ComputeStageImplBase.ensureJetEvents(this.computeStage, "This pipeline stage");
        FunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        return (StreamStage)this.computeStage.attach(new WindowGroupTransform(Collections.singletonList(this.computeStage.transform), this.wDef, Collections.singletonList(fnAdapter.adaptKeyFn(this.keyFn())), fnAdapter.adaptAggregateOperation1(aggrOp)), fnAdapter);
    }

    @Override
    @Nonnull
    public <T1, R> StreamStage<KeyedWindowResult<K, R>> aggregate2(@Nonnull StreamStageWithKey<T1, ? extends K> stage1, @Nonnull AggregateOperation2<? super T, ? super T1, ?, ? extends R> aggrOp) {
        ComputeStageImplBase.ensureJetEvents(this.computeStage, "This pipeline stage");
        ComputeStageImplBase.ensureJetEvents(((StageWithGroupingBase)((Object)stage1)).computeStage, "stage1");
        Transform upstream1 = ((StageWithGroupingBase)((Object)stage1)).computeStage.transform;
        FunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        return (StreamStage)this.computeStage.attach(new WindowGroupTransform(Arrays.asList(this.computeStage.transform, upstream1), this.wDef, Arrays.asList(fnAdapter.adaptKeyFn(this.keyFn()), fnAdapter.adaptKeyFn(stage1.keyFn())), JetEventFunctionAdapter.adaptAggregateOperation2(aggrOp)), fnAdapter);
    }

    @Override
    @Nonnull
    public <T1, T2, R> StreamStage<KeyedWindowResult<K, R>> aggregate3(@Nonnull StreamStageWithKey<T1, ? extends K> stage1, @Nonnull StreamStageWithKey<T2, ? extends K> stage2, @Nonnull AggregateOperation3<? super T, ? super T1, ? super T2, ?, ? extends R> aggrOp) {
        ComputeStageImplBase stageImpl1 = ((StageWithGroupingBase)((Object)stage1)).computeStage;
        ComputeStageImplBase stageImpl2 = ((StageWithGroupingBase)((Object)stage2)).computeStage;
        ComputeStageImplBase.ensureJetEvents(this.computeStage, "This pipeline stage");
        ComputeStageImplBase.ensureJetEvents(stageImpl1, "stage1");
        ComputeStageImplBase.ensureJetEvents(stageImpl2, "stage2");
        Transform transform1 = ((StageWithGroupingBase)((Object)stage1)).computeStage.transform;
        Transform transform2 = ((StageWithGroupingBase)((Object)stage2)).computeStage.transform;
        FunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        return (StreamStage)this.computeStage.attach(new WindowGroupTransform(Arrays.asList(this.computeStage.transform, transform1, transform2), this.wDef, Arrays.asList(fnAdapter.adaptKeyFn(this.keyFn()), fnAdapter.adaptKeyFn(stage1.keyFn()), fnAdapter.adaptKeyFn(stage2.keyFn())), JetEventFunctionAdapter.adaptAggregateOperation3(aggrOp)), fnAdapter);
    }
}

