/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.pipeline.Sink;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SinkImpl<T>
implements Sink<T> {
    private final String name;
    private final ProcessorMetaSupplier metaSupplier;
    private final boolean isTotalParallelismOne;
    private final FunctionEx<? super T, ?> inputPartitionKeyFunction;
    private boolean isAssignedToStage;

    public SinkImpl(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier, boolean isTotalParallelismOne, @Nullable FunctionEx<? super T, ?> inputPartitionKeyFunction) {
        if (inputPartitionKeyFunction != null && isTotalParallelismOne) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.metaSupplier = metaSupplier;
        this.isTotalParallelismOne = isTotalParallelismOne;
        this.inputPartitionKeyFunction = inputPartitionKeyFunction;
    }

    @Nonnull
    public ProcessorMetaSupplier metaSupplier() {
        return this.metaSupplier;
    }

    public boolean isTotalParallelismOne() {
        return this.isTotalParallelismOne;
    }

    public FunctionEx<? super T, ?> inputPartitionKeyFunction() {
        return this.inputPartitionKeyFunction;
    }

    @Override
    public String name() {
        return this.name;
    }

    void onAssignToStage() {
        if (this.isAssignedToStage) {
            throw new IllegalStateException("Sink " + this.name + " was already assigned to a sink stage");
        }
        this.isAssignedToStage = true;
    }
}

