/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.impl.CacheEntryIterationResult;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.cache.impl.operation.CacheEntryIteratorOperation;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheIterateEntriesCodec;
import com.hazelcast.client.impl.protocol.codec.MapFetchEntriesCodec;
import com.hazelcast.client.impl.protocol.codec.MapFetchWithQueryCodec;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Partition;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.ToIntFunctionEx;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.MigrationWatcher;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.iterator.AbstractCursor;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.map.impl.query.ResultSegment;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.IterationType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ReadMapOrCacheP<F extends ICompletableFuture, B, R>
extends AbstractProcessor {
    private static final int MAX_FETCH_SIZE = 16384;
    private final Reader<F, B, R> reader;
    private final int[] partitionIds;
    private final BooleanSupplier migrationWatcher;
    private final int[] readOffsets;
    private F[] readFutures;
    private List<R> currentBatch = Collections.emptyList();
    private int currentBatchPosition;
    private int currentPartitionIndex = -1;
    private int numCompletedPartitions;

    private ReadMapOrCacheP(@Nonnull Reader<F, B, R> reader, @Nonnull int[] partitionIds, @Nonnull BooleanSupplier migrationWatcher) {
        this.reader = reader;
        this.partitionIds = partitionIds;
        this.migrationWatcher = migrationWatcher;
        this.readOffsets = new int[partitionIds.length];
        Arrays.fill(this.readOffsets, Integer.MAX_VALUE);
    }

    @Override
    public boolean complete() {
        if (this.readFutures == null) {
            this.initialRead();
        }
        while (this.emitResultSet()) {
            if (this.tryGetNextResultSet()) continue;
            return this.numCompletedPartitions == this.partitionIds.length;
        }
        return false;
    }

    private void initialRead() {
        this.readFutures = new ICompletableFuture[this.partitionIds.length];
        for (int i = 0; i < this.readFutures.length; ++i) {
            this.readFutures[i] = this.reader.readBatch(this.partitionIds[i], Integer.MAX_VALUE);
        }
    }

    private boolean emitResultSet() {
        this.checkMigration();
        while (this.currentBatchPosition < this.currentBatch.size()) {
            Object result = this.reader.toObject(this.currentBatch.get(this.currentBatchPosition));
            if (result != null && !this.tryEmit(result)) {
                return false;
            }
            ++this.currentBatchPosition;
        }
        return true;
    }

    private boolean tryGetNextResultSet() {
        while (this.currentBatch.size() == this.currentBatchPosition && ++this.currentPartitionIndex < this.partitionIds.length) {
            if (this.readOffsets[this.currentPartitionIndex] < 0) {
                assert (this.readFutures[this.currentPartitionIndex] == null) : "future not null";
                continue;
            }
            F future = this.readFutures[this.currentPartitionIndex];
            if (!future.isDone()) continue;
            B result = this.toBatchResult(future);
            int nextIndex = this.reader.toNextIndex(result);
            if (nextIndex < 0) {
                ++this.numCompletedPartitions;
            } else assert (!this.currentBatch.isEmpty()) : "empty but not terminal batch";
            this.currentBatch = this.reader.toRecordSet(result);
            this.currentBatchPosition = 0;
            this.readOffsets[this.currentPartitionIndex] = nextIndex;
            this.readFutures[this.currentPartitionIndex] = this.readOffsets[this.currentPartitionIndex] >= 0 ? this.reader.readBatch(this.partitionIds[this.currentPartitionIndex], this.readOffsets[this.currentPartitionIndex]) : null;
        }
        if (this.currentPartitionIndex == this.partitionIds.length) {
            this.currentPartitionIndex = -1;
            return false;
        }
        return true;
    }

    private B toBatchResult(F future) {
        B result;
        try {
            result = this.reader.toBatchResult(future);
        }
        catch (ExecutionException e) {
            Throwable ex = ExceptionUtil.peel(e);
            if (ex instanceof HazelcastSerializationException) {
                throw new JetException("Serialization error when reading the map: are the key, value, predicate and projection classes visible to IMDG? You need to use User Code Deployment, adding the classes to JetConfig isn't enough", e);
            }
            throw ExceptionUtil.rethrow(ex);
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.rethrow(e);
        }
        return result;
    }

    private void checkMigration() {
        if (this.migrationWatcher.getAsBoolean()) {
            throw new RestartableException("Partition migration detected");
        }
    }

    static class RemoteMapQueryReader
    extends Reader<ClientInvocationFuture, MapFetchWithQueryCodec.ResponseParameters, Data> {
        private final Predicate predicate;
        private final Projection projection;
        private final ClientMapProxy clientMapProxy;

        RemoteMapQueryReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String mapName, @Nonnull Predicate predicate, @Nonnull Projection projection) {
            super(mapName, r -> r.nextTableIndexToReadFrom, r -> r.results);
            this.predicate = predicate;
            this.projection = projection;
            this.clientMapProxy = (ClientMapProxy)hzInstance.getMap(mapName);
            this.serializationService = this.clientMapProxy.getContext().getSerializationService();
        }

        @Override
        @Nonnull
        public ClientInvocationFuture readBatch(int partitionId, int offset) {
            ClientMessage request = MapFetchWithQueryCodec.encodeRequest(this.objectName, offset, 16384, this.serializationService.toData(this.projection), this.serializationService.toData(this.predicate));
            ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstanceImpl)this.clientMapProxy.getContext().getHazelcastInstance(), request, this.objectName, partitionId);
            return clientInvocation.invoke();
        }

        @Override
        @Nonnull
        public MapFetchWithQueryCodec.ResponseParameters toBatchResult(@Nonnull ClientInvocationFuture future) throws ExecutionException, InterruptedException {
            return MapFetchWithQueryCodec.decodeResponse((ClientMessage)future.get());
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Data data) {
            return this.serializationService.toObject(data);
        }
    }

    static class RemoteMapReader
    extends Reader<ClientInvocationFuture, MapFetchEntriesCodec.ResponseParameters, Map.Entry<Data, Data>> {
        private final ClientMapProxy clientMapProxy;

        RemoteMapReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String mapName) {
            super(mapName, r -> r.tableIndex, r -> r.entries);
            this.clientMapProxy = (ClientMapProxy)hzInstance.getMap(mapName);
            this.serializationService = this.clientMapProxy.getContext().getSerializationService();
        }

        @Override
        @Nonnull
        public ClientInvocationFuture readBatch(int partitionId, int offset) {
            ClientMessage request = MapFetchEntriesCodec.encodeRequest(this.objectName, partitionId, offset, 16384);
            ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstanceImpl)this.clientMapProxy.getContext().getHazelcastInstance(), request, this.objectName, partitionId);
            return clientInvocation.invoke();
        }

        @Override
        @Nonnull
        public MapFetchEntriesCodec.ResponseParameters toBatchResult(@Nonnull ClientInvocationFuture future) throws ExecutionException, InterruptedException {
            return MapFetchEntriesCodec.decodeResponse((ClientMessage)future.get());
        }

        @Nullable
        public Map.Entry<Data, Data> toObject(@Nonnull Map.Entry<Data, Data> entry) {
            return new LazyMapEntry<Data, Data>(entry.getKey(), entry.getValue(), this.serializationService);
        }
    }

    static class LocalMapQueryReader
    extends Reader<InternalCompletableFuture<ResultSegment>, ResultSegment, QueryResultRow> {
        private final Predicate predicate;
        private final Projection projection;
        private final MapProxyImpl mapProxyImpl;

        LocalMapQueryReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String mapName, @Nonnull Predicate predicate, @Nonnull Projection projection) {
            super(mapName, ResultSegment::getNextTableIndexToReadFrom, r -> ((QueryResult)r.getResult()).getRows());
            this.predicate = predicate;
            this.projection = projection;
            this.mapProxyImpl = (MapProxyImpl)hzInstance.getMap(mapName);
            this.serializationService = ((HazelcastInstanceImpl)hzInstance).getSerializationService();
        }

        @Override
        @Nonnull
        public InternalCompletableFuture<ResultSegment> readBatch(int partitionId, int offset) {
            MapOperationProvider operationProvider = this.mapProxyImpl.getOperationProvider();
            MapOperation op = operationProvider.createFetchWithQueryOperation(this.objectName, offset, 16384, Query.of().mapName(this.objectName).iterationType(IterationType.VALUE).predicate(this.predicate).projection(this.projection).build());
            return this.mapProxyImpl.getOperationService().invokeOnPartition(this.mapProxyImpl.getServiceName(), op, partitionId);
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull QueryResultRow record) {
            return this.serializationService.toObject(record.getValue());
        }
    }

    static class LocalMapReader
    extends Reader<InternalCompletableFuture<MapEntriesWithCursor>, MapEntriesWithCursor, Map.Entry<Data, Data>> {
        private final MapProxyImpl mapProxyImpl;

        LocalMapReader(@Nonnull HazelcastInstance hzInstance, @Nonnull String mapName) {
            super(mapName, AbstractCursor::getNextTableIndexToReadFrom, AbstractCursor::getBatch);
            this.mapProxyImpl = (MapProxyImpl)hzInstance.getMap(mapName);
            this.serializationService = ((HazelcastInstanceImpl)hzInstance).getSerializationService();
        }

        @Override
        @Nonnull
        public InternalCompletableFuture<MapEntriesWithCursor> readBatch(int partitionId, int offset) {
            MapOperationProvider operationProvider = this.mapProxyImpl.getOperationProvider();
            MapOperation op = operationProvider.createFetchEntriesOperation(this.objectName, offset, 16384);
            return this.mapProxyImpl.getOperationService().invokeOnPartition(this.mapProxyImpl.getServiceName(), op, partitionId);
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Map.Entry<Data, Data> dataEntry) {
            return new LazyMapEntry(dataEntry.getKey(), dataEntry.getValue(), this.serializationService);
        }
    }

    static class RemoteCacheReader
    extends Reader<ClientInvocationFuture, CacheIterateEntriesCodec.ResponseParameters, Map.Entry<Data, Data>> {
        private final ClientCacheProxy clientCacheProxy;

        RemoteCacheReader(HazelcastInstance hzInstance, @Nonnull String cacheName) {
            super(cacheName, r -> r.tableIndex, r -> r.entries);
            this.clientCacheProxy = (ClientCacheProxy)hzInstance.getCacheManager().getCache(cacheName);
            this.serializationService = this.clientCacheProxy.getContext().getSerializationService();
        }

        @Override
        @Nonnull
        public ClientInvocationFuture readBatch(int partitionId, int offset) {
            String name = this.clientCacheProxy.getPrefixedName();
            ClientMessage request = CacheIterateEntriesCodec.encodeRequest(name, partitionId, offset, 16384);
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientCacheProxy.getContext().getHazelcastInstance();
            return new ClientInvocation(client, request, name, partitionId).invoke();
        }

        @Override
        @Nonnull
        public CacheIterateEntriesCodec.ResponseParameters toBatchResult(@Nonnull ClientInvocationFuture future) throws ExecutionException, InterruptedException {
            return CacheIterateEntriesCodec.decodeResponse((ClientMessage)future.get());
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Map.Entry<Data, Data> dataEntry) {
            return new LazyMapEntry(dataEntry.getKey(), dataEntry.getValue(), this.serializationService);
        }
    }

    static class LocalCacheReader
    extends Reader<InternalCompletableFuture<CacheEntryIterationResult>, CacheEntryIterationResult, Map.Entry<Data, Data>> {
        private final CacheProxy cacheProxy;

        LocalCacheReader(HazelcastInstance hzInstance, @Nonnull String cacheName) {
            super(cacheName, CacheEntryIterationResult::getTableIndex, CacheEntryIterationResult::getEntries);
            this.cacheProxy = (CacheProxy)hzInstance.getCacheManager().getCache(cacheName);
            this.serializationService = (InternalSerializationService)this.cacheProxy.getNodeEngine().getSerializationService();
        }

        @Override
        @Nonnull
        public InternalCompletableFuture<CacheEntryIterationResult> readBatch(int partitionId, int offset) {
            CacheEntryIteratorOperation op = new CacheEntryIteratorOperation(this.cacheProxy.getPrefixedName(), offset, 16384);
            OperationService operationService = this.cacheProxy.getOperationService();
            return operationService.invokeOnPartition(this.cacheProxy.getServiceName(), op, partitionId);
        }

        @Override
        @Nullable
        public Object toObject(@Nonnull Map.Entry<Data, Data> dataEntry) {
            return new LazyMapEntry(dataEntry.getKey(), dataEntry.getValue(), this.serializationService);
        }
    }

    static abstract class Reader<F extends ICompletableFuture, B, R> {
        protected final String objectName;
        protected InternalSerializationService serializationService;
        private final ToIntFunctionEx<B> toNextIndexFn;
        private FunctionEx<B, List<R>> toRecordSetFn;

        Reader(@Nonnull String objectName, @Nonnull ToIntFunctionEx<B> toNextIndexFn, @Nonnull FunctionEx<B, List<R>> toRecordSetFn) {
            this.objectName = objectName;
            this.toNextIndexFn = toNextIndexFn;
            this.toRecordSetFn = toRecordSetFn;
        }

        @Nonnull
        abstract F readBatch(int var1, int var2);

        @Nonnull
        B toBatchResult(@Nonnull F future) throws ExecutionException, InterruptedException {
            return (B)future.get();
        }

        final int toNextIndex(@Nonnull B result) {
            return this.toNextIndexFn.applyAsInt(result);
        }

        @Nonnull
        final List<R> toRecordSet(@Nonnull B result) {
            return this.toRecordSetFn.apply(result);
        }

        @Nullable
        abstract Object toObject(@Nonnull R var1);
    }

    static class RemoteProcessorSupplier<F extends ICompletableFuture, B, R>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final String clientXml;
        private final FunctionEx<HazelcastInstance, Reader<F, B, R>> readerSupplier;
        private transient HazelcastClientProxy client;
        private transient MigrationWatcher migrationWatcher;
        private transient int totalParallelism;
        private transient int baseIndex;

        RemoteProcessorSupplier(@Nonnull String clientXml, FunctionEx<HazelcastInstance, Reader<F, B, R>> readerSupplier) {
            this.clientXml = clientXml;
            this.readerSupplier = readerSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.client = (HazelcastClientProxy)HazelcastClient.newHazelcastClient(ImdgUtil.asClientConfig(this.clientXml));
            this.migrationWatcher = new MigrationWatcher(this.client);
            this.totalParallelism = context.totalParallelism();
            this.baseIndex = context.memberIndex() * context.localParallelism();
        }

        @Override
        public void close(Throwable error) {
            if (this.migrationWatcher != null) {
                this.migrationWatcher.deregister();
            }
            if (this.client != null) {
                this.client.shutdown();
            }
        }

        @Nonnull
        public List<Processor> get(int count) {
            int remotePartitionCount = this.client.client.getClientPartitionService().getPartitionCount();
            BooleanSupplier watcherInstance = this.migrationWatcher.createWatcher();
            return IntStream.range(0, count).mapToObj(i -> {
                int[] partitionIds = Util.roundRobinPart(remotePartitionCount, this.totalParallelism, this.baseIndex + i);
                return new ReadMapOrCacheP(this.readerSupplier.apply(this.client), partitionIds, watcherInstance);
            }).collect(Collectors.toList());
        }
    }

    private static final class LocalProcessorSupplier<F extends ICompletableFuture, B, R>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final Function<HazelcastInstance, Reader<F, B, R>> readerSupplier;
        private final List<Integer> memberPartitions;
        private transient BooleanSupplier migrationWatcher;
        private transient HazelcastInstanceImpl hzInstance;

        private LocalProcessorSupplier(Function<HazelcastInstance, Reader<F, B, R>> readerSupplier, List<Integer> memberPartitions) {
            this.readerSupplier = readerSupplier;
            this.memberPartitions = memberPartitions;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.hzInstance = (HazelcastInstanceImpl)context.jetInstance().getHazelcastInstance();
            JetService jetService = (JetService)this.hzInstance.node.nodeEngine.getService("hz:impl:jetService");
            this.migrationWatcher = jetService.getSharedMigrationWatcher().createWatcher();
        }

        @Nonnull
        public List<Processor> get(int count) {
            return Util.processorToPartitions(count, this.memberPartitions).values().stream().map(partitions -> partitions.stream().mapToInt(Integer::intValue).toArray()).map(partitions -> new ReadMapOrCacheP(this.readerSupplier.apply(this.hzInstance), (int[])partitions, this.migrationWatcher)).collect(Collectors.toList());
        }
    }

    static class LocalProcessorMetaSupplier<F extends ICompletableFuture, B, R>
    implements ProcessorMetaSupplier {
        private static final long serialVersionUID = 1L;
        private final FunctionEx<HazelcastInstance, Reader<F, B, R>> readerSupplier;
        private transient Map<Address, List<Integer>> addrToPartitions;

        LocalProcessorMetaSupplier(@Nonnull FunctionEx<HazelcastInstance, Reader<F, B, R>> readerSupplier) {
            this.readerSupplier = readerSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorMetaSupplier.Context context) {
            Set<Partition> partitions = context.jetInstance().getHazelcastInstance().getPartitionService().getPartitions();
            this.addrToPartitions = partitions.stream().collect(Collectors.groupingBy(p -> p.getOwner().getAddress(), Collectors.mapping(Partition::getPartitionId, Collectors.toList())));
        }

        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            return address -> new LocalProcessorSupplier(this.readerSupplier, this.addrToPartitions.get(address));
        }
    }
}

