/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.connector.HazelcastWriters;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public abstract class AsyncHazelcastWriterP
implements Processor {
    static final int MAX_PARALLEL_ASYNC_OPS_DEFAULT = 1000;
    private final int maxParallelAsyncOps;
    private final AtomicInteger numConcurrentOps = new AtomicInteger();
    private final AtomicReference<Throwable> firstError = new AtomicReference();
    private final HazelcastInstance instance;
    private final boolean isLocal;
    private final ExecutionCallback callback = ImdgUtil.callbackOf(response -> this.numConcurrentOps.decrementAndGet(), exception -> {
        this.numConcurrentOps.decrementAndGet();
        if (exception != null) {
            this.firstError.compareAndSet((Throwable)null, (Throwable)exception);
        }
    });

    AsyncHazelcastWriterP(HazelcastInstance instance, int maxParallelAsyncOps) {
        this.instance = instance;
        this.maxParallelAsyncOps = maxParallelAsyncOps;
        this.isLocal = ImdgUtil.isMemberInstance(instance);
    }

    @Override
    public final boolean tryProcess() {
        this.flush();
        return true;
    }

    @Override
    public final void process(int ordinal, @Nonnull Inbox inbox) {
        this.checkError();
        try {
            this.processInternal(inbox);
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw HazelcastWriters.handleInstanceNotActive(e, this.isLocal());
        }
    }

    @Override
    public final boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    @Override
    public final boolean saveToSnapshot() {
        return this.flush() && this.asyncCallsDone();
    }

    @Override
    public final boolean complete() {
        return this.flush() && this.asyncCallsDone();
    }

    private boolean flush() {
        boolean result;
        this.checkError();
        try {
            result = this.flushInternal();
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw HazelcastWriters.handleInstanceNotActive(e, this.isLocal());
        }
        return result;
    }

    @CheckReturnValue
    protected boolean flushInternal() {
        return true;
    }

    protected abstract void processInternal(Inbox var1);

    protected final void setCallback(ICompletableFuture future) {
        future.andThen(this.callback);
    }

    @CheckReturnValue
    protected final boolean tryAcquirePermit() {
        return Util.tryIncrement(this.numConcurrentOps, 1, this.maxParallelAsyncOps);
    }

    @CheckReturnValue
    protected final int tryAcquirePermits(int desiredNumber) {
        int next;
        int prev;
        do {
            if ((next = Math.min((prev = this.numConcurrentOps.get()) + desiredNumber, this.maxParallelAsyncOps)) != prev) continue;
            return 0;
        } while (!this.numConcurrentOps.compareAndSet(prev, next));
        return next - prev;
    }

    protected final HazelcastInstance instance() {
        return this.instance;
    }

    protected final boolean isLocal() {
        return this.isLocal;
    }

    private void checkError() {
        Throwable t = this.firstError.get();
        if (t instanceof HazelcastInstanceNotActiveException) {
            throw HazelcastWriters.handleInstanceNotActive((HazelcastInstanceNotActiveException)t, this.isLocal());
        }
        if (t != null) {
            throw ExceptionUtil.sneakyThrow(t);
        }
    }

    private boolean asyncCallsDone() {
        boolean allWritten = this.numConcurrentOps.get() == 0;
        this.checkError();
        return allWritten;
    }
}

