/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.config.Config;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.config.MetricsConfig;
import com.hazelcast.jet.core.JetProperties;
import com.hazelcast.jet.impl.config.ConfigProvider;
import com.hazelcast.jet.impl.config.XmlJetConfigBuilder;
import com.hazelcast.jet.impl.config.YamlJetConfigBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;

public class JetConfig {
    public static final int DEFAULT_JET_MULTICAST_PORT = 54326;
    public static final String DEFAULT_GROUP_NAME = "jet";
    private static final ILogger LOGGER = Logger.getLogger(JetConfig.class);
    private Config hazelcastConfig = JetConfig.defaultHazelcastConfig();
    private InstanceConfig instanceConfig = new InstanceConfig();
    private EdgeConfig defaultEdgeConfig = new EdgeConfig();
    private MetricsConfig metricsConfig = new MetricsConfig();
    private Properties properties = new Properties();

    @Nonnull
    public static JetConfig loadDefault() {
        return ConfigProvider.locateAndGetJetConfig();
    }

    @Nonnull
    public static JetConfig loadDefault(Properties properties) {
        Preconditions.checkTrue(properties != null, "properties can't be null");
        return ConfigProvider.locateAndGetJetConfig(properties);
    }

    @Nonnull
    public static JetConfig loadFromClasspath(ClassLoader classLoader, String resource) {
        return JetConfig.loadFromClasspath(classLoader, resource, System.getProperties());
    }

    @Nonnull
    public static JetConfig loadFromClasspath(ClassLoader classLoader, String resource, Properties properties) {
        Preconditions.checkTrue(classLoader != null, "classLoader can't be null");
        Preconditions.checkTrue(resource != null, "resource can't be null");
        Preconditions.checkTrue(properties != null, "properties can't be null");
        LOGGER.info("Configuring Hazelcast Jet from '" + resource + "'.");
        InputStream in = classLoader.getResourceAsStream(resource);
        Preconditions.checkTrue(in != null, "Specified resource '" + resource + "' could not be found!");
        if (resource.endsWith(".xml")) {
            return JetConfig.loadXmlFromStream(in, properties);
        }
        if (resource.endsWith(".yaml") || resource.endsWith(".yml")) {
            return JetConfig.loadYamlFromStream(in, properties);
        }
        throw new IllegalArgumentException("Unknown configuration file extension");
    }

    @Nonnull
    public static JetConfig loadFromFile(File configFile) throws FileNotFoundException {
        return JetConfig.loadFromFile(configFile, System.getProperties());
    }

    @Nonnull
    public static JetConfig loadFromFile(File configFile, Properties properties) throws FileNotFoundException {
        Preconditions.checkTrue(configFile != null, "configFile can't be null");
        Preconditions.checkTrue(properties != null, "properties can't be null");
        LOGGER.info("Configuring Hazelcast Jet from '" + configFile.getAbsolutePath() + "'.");
        String path = configFile.getPath();
        FileInputStream in = new FileInputStream(configFile);
        if (path.endsWith(".xml")) {
            return JetConfig.loadXmlFromStream(in, properties);
        }
        if (path.endsWith(".yaml") || path.endsWith(".yml")) {
            return JetConfig.loadYamlFromStream(in, properties);
        }
        throw new IllegalArgumentException("Unknown configuration file extension");
    }

    @Nonnull
    public static JetConfig loadXmlFromStream(@Nonnull InputStream configStream) {
        return JetConfig.loadXmlFromStream(configStream, System.getProperties());
    }

    @Nonnull
    public static JetConfig loadXmlFromStream(@Nonnull InputStream configStream, @Nonnull Properties properties) {
        return new XmlJetConfigBuilder(configStream).setProperties(properties).build();
    }

    @Nonnull
    public static JetConfig loadXmlFromString(String xml) {
        return JetConfig.loadXmlFromString(xml, System.getProperties());
    }

    @Nonnull
    public static JetConfig loadXmlFromString(String xml, Properties properties) {
        LOGGER.info("Configuring Hazelcast Jet from 'in-memory xml'.");
        if (StringUtil.isNullOrEmptyAfterTrim(xml)) {
            throw new IllegalArgumentException("XML configuration is null or empty! Please use a well-structured xml.");
        }
        Preconditions.checkTrue(properties != null, "properties can't be null");
        ByteArrayInputStream in = new ByteArrayInputStream(StringUtil.stringToBytes(xml));
        return new XmlJetConfigBuilder(in).setProperties(properties).build();
    }

    @Nonnull
    public static JetConfig loadYamlFromStream(@Nonnull InputStream configStream) {
        return JetConfig.loadYamlFromStream(configStream, System.getProperties());
    }

    @Nonnull
    public static JetConfig loadYamlFromStream(@Nonnull InputStream configStream, @Nonnull Properties properties) {
        return new YamlJetConfigBuilder(configStream).setProperties(properties).build();
    }

    @Nonnull
    public static JetConfig loadYamlFromString(String yaml) {
        return JetConfig.loadYamlFromString(yaml, System.getProperties());
    }

    @Nonnull
    public static JetConfig loadYamlFromString(String yaml, Properties properties) {
        LOGGER.info("Configuring Hazelcast Jet from 'in-memory yaml'.");
        if (StringUtil.isNullOrEmptyAfterTrim(yaml)) {
            throw new IllegalArgumentException("YAML configuration is null or empty! Please use a well-structured YAML.");
        }
        Preconditions.checkTrue(properties != null, "properties can't be null");
        ByteArrayInputStream in = new ByteArrayInputStream(StringUtil.stringToBytes(yaml));
        return new YamlJetConfigBuilder(in).setProperties(properties).build();
    }

    @Nonnull
    @Deprecated
    public static JetConfig loadFromClasspath(@Nonnull String resource) {
        return JetConfig.loadFromClasspath(resource, System.getProperties());
    }

    @Nonnull
    @Deprecated
    public static JetConfig loadFromClasspath(@Nonnull String resource, @Nonnull Properties properties) {
        LOGGER.info("Configuring Hazelcast Jet from '" + resource + "' on classpath");
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            throw new IllegalArgumentException("Specified resource '" + resource + "' cannot be found on classpath");
        }
        return JetConfig.loadFromStream(stream, properties);
    }

    @Nonnull
    @Deprecated
    public static JetConfig loadFromStream(@Nonnull InputStream configStream) {
        return JetConfig.loadFromStream(configStream, System.getProperties());
    }

    @Nonnull
    @Deprecated
    public static JetConfig loadFromStream(@Nonnull InputStream configStream, @Nonnull Properties properties) {
        return XmlJetConfigBuilder.loadConfig(configStream, properties);
    }

    @Nonnull
    public Config getHazelcastConfig() {
        return this.hazelcastConfig;
    }

    @Nonnull
    public JetConfig setHazelcastConfig(@Nonnull Config config) {
        Preconditions.checkNotNull(config, "config");
        this.hazelcastConfig = config;
        return this;
    }

    @Nonnull
    public InstanceConfig getInstanceConfig() {
        return this.instanceConfig;
    }

    @Nonnull
    public JetConfig setInstanceConfig(@Nonnull InstanceConfig instanceConfig) {
        Preconditions.checkNotNull(instanceConfig, "instanceConfig");
        this.instanceConfig = instanceConfig;
        return this;
    }

    @Nonnull
    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    @Nonnull
    public JetConfig setMetricsConfig(@Nonnull MetricsConfig metricsConfig) {
        Preconditions.checkNotNull(metricsConfig, "metricsConfig");
        this.metricsConfig = metricsConfig;
        return this;
    }

    @Nonnull
    public Properties getProperties() {
        return this.properties;
    }

    @Nonnull
    public JetConfig setProperties(@Nonnull Properties properties) {
        Preconditions.checkNotNull(properties, "properties");
        this.properties = properties;
        return this;
    }

    @Nonnull
    public JetConfig setProperty(@Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(value, "value");
        this.properties.put(name, value);
        return this;
    }

    @Nonnull
    public EdgeConfig getDefaultEdgeConfig() {
        return this.defaultEdgeConfig;
    }

    @Nonnull
    public JetConfig setDefaultEdgeConfig(@Nonnull EdgeConfig defaultEdgeConfig) {
        Preconditions.checkNotNull(defaultEdgeConfig, "defaultEdgeConfig");
        this.defaultEdgeConfig = defaultEdgeConfig;
        return this;
    }

    private static Config defaultHazelcastConfig() {
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(54326);
        config.getGroupConfig().setName(DEFAULT_GROUP_NAME);
        config.getHotRestartPersistenceConfig().setBaseDir(new File(JetConfig.jetHome(), "recovery").getAbsoluteFile());
        return config;
    }

    private static String jetHome() {
        return new File(System.getProperty(JetProperties.JET_HOME.getName(), JetProperties.JET_HOME.getDefaultValue())).getAbsolutePath();
    }

    static {
        String value = JetConfig.jetHome();
        LOGGER.info("jet.home is " + value);
        System.setProperty(JetProperties.JET_HOME.getName(), value);
    }
}

