/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.server;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.nio.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.logging.LogManager;

public final class StartServer {
    private StartServer() {
    }

    public static void main(String[] args) throws Exception {
        StartServer.configureLogging();
        JetInstance jet = Jet.newJetInstance();
        StartServer.printMemberPort(jet.getHazelcastInstance());
    }

    public static void configureLogging() throws IOException {
        InputStream input = StartServer.class.getClassLoader().getResourceAsStream("logging.properties");
        LogManager.getLogManager().readConfiguration(input);
    }

    private static void printMemberPort(HazelcastInstance hz) throws Exception {
        String printPort = System.getProperty("print.port");
        if (printPort != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter("ports" + File.separator + printPort, "UTF-8");
                printWriter.println(hz.getCluster().getLocalMember().getAddress().getPort());
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(printWriter);
                throw throwable;
            }
            IOUtil.closeResource(printWriter);
        }
    }
}

