/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.FunctionEx;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class WrappingProcessorSupplier
implements ProcessorSupplier {
    private ProcessorSupplier wrapped;
    private FunctionEx<Processor, Processor> wrapperSupplier;

    public WrappingProcessorSupplier(ProcessorSupplier wrapped, FunctionEx<Processor, Processor> wrapperSupplier) {
        this.wrapped = wrapped;
        this.wrapperSupplier = wrapperSupplier;
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        Collection<? extends Processor> processors = this.wrapped.get(count);
        return processors.stream().map(this.wrapperSupplier).collect(Collectors.toList());
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        this.wrapped.init(context);
    }

    @Override
    public void close(Throwable error) throws Exception {
        this.wrapped.close(error);
    }
}

