/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.IMap;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.impl.JobExecutionRecord;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.MasterContext;
import com.hazelcast.jet.impl.SnapshotValidationRecord;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.operation.SnapshotOperation;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.Operation;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class MasterSnapshotContext {
    final MasterContext mc;
    private final ILogger logger;
    private boolean snapshotInProgress;
    @Nonnull
    private volatile CompletableFuture<Void> terminalSnapshotFuture = CompletableFuture.completedFuture(null);
    private final Queue<Tuple3<String, Boolean, CompletableFuture<Void>>> snapshotQueue = new LinkedList<Tuple3<String, Boolean, CompletableFuture<Void>>>();

    MasterSnapshotContext(MasterContext masterContext, ILogger logger) {
        this.mc = masterContext;
        this.logger = logger;
    }

    void enqueueSnapshot(String snapshotMapName, boolean isTerminal, CompletableFuture<Void> future) {
        this.snapshotQueue.add(Tuple3.tuple3(snapshotMapName, isTerminal, future));
    }

    void startScheduledSnapshot(long executionId) {
        this.mc.lock();
        try {
            if (this.mc.jobStatus() != JobStatus.RUNNING) {
                this.logger.fine("Not beginning snapshot, " + this.mc.jobIdString() + " is not RUNNING, but " + (Object)((Object)this.mc.jobStatus()));
                return;
            }
            if (this.mc.executionId() != executionId) {
                this.logger.fine("Not beginning snapshot since unexpected execution ID received for " + this.mc.jobIdString() + ". Received execution ID: " + Util.idToString(executionId));
                return;
            }
            this.snapshotQueue.add(Tuple3.tuple3(null, false, null));
        }
        finally {
            this.mc.unlock();
        }
        this.tryBeginSnapshot();
    }

    void tryBeginSnapshot() {
        this.mc.coordinationService().submitToCoordinatorThread(() -> {
            CompletableFuture<Void> future;
            boolean isTerminal;
            String snapshotMapName;
            this.mc.lock();
            try {
                if (this.mc.jobStatus() != JobStatus.RUNNING) {
                    this.logger.fine("Not beginning snapshot, " + this.mc.jobIdString() + " is not RUNNING, but " + (Object)((Object)this.mc.jobStatus()));
                    return;
                }
                if (this.snapshotInProgress) {
                    this.logger.fine("Not beginning snapshot since one is already in progress " + this.mc.jobIdString());
                    return;
                }
                if (this.terminalSnapshotFuture.isDone()) {
                    this.logger.fine("Not beginning snapshot since terminal snapshot is already completed " + this.mc.jobIdString());
                    return;
                }
                Tuple3<String, Boolean, CompletableFuture<Void>> requestedSnapshot = this.snapshotQueue.poll();
                if (requestedSnapshot == null) {
                    return;
                }
                this.snapshotInProgress = true;
                snapshotMapName = requestedSnapshot.f0();
                isTerminal = requestedSnapshot.f1();
                future = requestedSnapshot.f2();
                this.mc.jobExecutionRecord().startNewSnapshot(snapshotMapName);
            }
            finally {
                this.mc.unlock();
            }
            this.mc.writeJobExecutionRecord(false);
            long newSnapshotId = this.mc.jobExecutionRecord().ongoingSnapshotId();
            boolean isExport = snapshotMapName != null;
            String finalMapName = isExport ? JobRepository.exportedSnapshotMapName(snapshotMapName) : JobRepository.snapshotDataMapName(this.mc.jobId(), this.mc.jobExecutionRecord().ongoingDataMapIndex());
            this.mc.nodeEngine().getHazelcastInstance().getMap(finalMapName).clear();
            LoggingUtil.logFine(this.logger, "Starting snapshot %d for %s, terminal: %s, writing to: %s", newSnapshotId, this.mc.jobIdString(), isTerminal ? "yes" : "no", snapshotMapName);
            Function<ExecutionPlan, Operation> factory = plan -> new SnapshotOperation(this.mc.jobId(), this.mc.executionId(), newSnapshotId, finalMapName, isTerminal);
            long localExecutionId = this.mc.executionId();
            this.mc.invokeOnParticipants(factory, responses -> this.onSnapshotCompleted((Collection<Map.Entry<MemberInfo, Object>>)responses, localExecutionId, newSnapshotId, finalMapName, isExport, isTerminal, future), null, true);
        });
    }

    private void onSnapshotCompleted(Collection<Map.Entry<MemberInfo, Object>> responses, long executionId, long snapshotId, String snapshotMapName, boolean wasExport, boolean wasTerminal, @Nullable CompletableFuture<Void> future) {
        this.mc.coordinationService().submitToCoordinatorThread(() -> {
            boolean isSuccess;
            SnapshotOperation.SnapshotOperationResult mergedResult = new SnapshotOperation.SnapshotOperationResult();
            for (Map.Entry entry : responses) {
                Object response = entry.getValue();
                if (response instanceof Throwable) {
                    response = new SnapshotOperation.SnapshotOperationResult(0L, 0L, 0L, (Throwable)response);
                }
                mergedResult.merge((SnapshotOperation.SnapshotOperationResult)response);
            }
            IMap<SnapshotValidationRecord.SnapshotValidationKey, SnapshotValidationRecord> snapshotMap = this.mc.nodeEngine().getHazelcastInstance().getMap(snapshotMapName);
            try {
                SnapshotValidationRecord validationRecord = new SnapshotValidationRecord(snapshotId, mergedResult.getNumChunks(), mergedResult.getNumBytes(), this.mc.jobExecutionRecord().ongoingSnapshotStartTime(), this.mc.jobId(), this.mc.jobName(), this.mc.jobRecord().getDagJson());
                SnapshotValidationRecord oldValue = snapshotMap.put(SnapshotValidationRecord.KEY, validationRecord);
                if (snapshotMapName.startsWith("__jet.exportedSnapshot.")) {
                    String snapshotName = snapshotMapName.substring("__jet.exportedSnapshot.".length());
                    this.mc.jobRepository().cacheValidationRecord(snapshotName, validationRecord);
                }
                if (oldValue != null) {
                    this.logger.severe("SnapshotValidationRecord overwritten after writing to '" + snapshotMapName + "' for " + this.mc.jobIdString() + ": snapshot data might be corrupted");
                }
            }
            catch (Exception e) {
                mergedResult.merge(new SnapshotOperation.SnapshotOperationResult(0L, 0L, 0L, e));
            }
            boolean bl = isSuccess = mergedResult.getError() == null;
            if (!isSuccess) {
                this.logger.warning(this.mc.jobIdString() + " snapshot " + snapshotId + " failed on some member(s), one of the failures: " + mergedResult.getError());
                try {
                    snapshotMap.clear();
                }
                catch (Exception e) {
                    this.logger.warning(this.mc.jobIdString() + ": failed to clear snapshot map '" + snapshotMapName + "' after a failure", e);
                }
            }
            JobExecutionRecord.SnapshotStats stats = this.mc.jobExecutionRecord().ongoingSnapshotDone(mergedResult.getNumBytes(), mergedResult.getNumKeys(), mergedResult.getNumChunks(), mergedResult.getError());
            this.mc.writeJobExecutionRecord(false);
            if (this.logger.isFineEnabled()) {
                this.logger.fine(String.format("Snapshot %d for %s completed with status %s in %dms, %,d bytes, %,d keys in %,d chunks, stored in '%s'", snapshotId, this.mc.jobIdString(), isSuccess ? "SUCCESS" : "FAILURE", stats.duration(), stats.numBytes(), stats.numKeys(), stats.numChunks(), snapshotMapName));
            }
            if (!wasExport) {
                this.mc.jobRepository().clearSnapshotData(this.mc.jobId(), this.mc.jobExecutionRecord().ongoingDataMapIndex());
            }
            if (future != null) {
                if (isSuccess) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(new JetException(mergedResult.getError()));
                }
            }
            this.mc.lock();
            try {
                if (this.mc.executionId() != executionId) {
                    this.logger.fine("Not completing terminalSnapshotFuture on " + this.mc.jobIdString() + ", new execution already started, snapshot was for executionId=" + Util.idToString(executionId));
                    return;
                }
                assert (this.snapshotInProgress) : "snapshot not in progress";
                this.snapshotInProgress = false;
                if (wasTerminal) {
                    boolean completedNow = this.terminalSnapshotFuture.complete(null);
                    assert (completedNow) : "terminalSnapshotFuture was already completed";
                    if (!isSuccess) {
                        this.mc.jobContext().cancelExecutionInvocations(this.mc.jobId(), this.mc.executionId(), null);
                    }
                } else if (!wasExport) {
                    this.mc.coordinationService().scheduleSnapshot(this.mc, executionId);
                }
            }
            finally {
                this.mc.unlock();
            }
            this.tryBeginSnapshot();
        });
    }

    CompletableFuture<Void> terminalSnapshotFuture() {
        return this.terminalSnapshotFuture;
    }

    void onExecutionStarted() {
        this.snapshotInProgress = false;
        assert (this.snapshotQueue.isEmpty()) : "snapshotQueue not empty";
        this.terminalSnapshotFuture = new CompletableFuture();
    }

    void onExecutionTerminated() {
        for (Tuple3 tuple3 : this.snapshotQueue) {
            if (tuple3.f2() == null) continue;
            ((CompletableFuture)tuple3.f2()).completeExceptionally(new JetException("Execution completed before snapshot executed"));
        }
        this.snapshotQueue.clear();
    }

    public ILogger logger() {
        return this.logger;
    }
}

