/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.datamodel.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ItemsByTag {
    private static final Object NONE = new Object();
    private final Map<Tag<?>, Object> map = new HashMap();

    @Nonnull
    public static ItemsByTag itemsByTag(Object ... tagsAndVals) {
        ItemsByTag ibt = new ItemsByTag();
        int i = 0;
        while (i < tagsAndVals.length) {
            ibt.put((Tag)tagsAndVals[i++], tagsAndVals[i++]);
        }
        return ibt;
    }

    @Nullable
    public <E> E get(@Nonnull Tag<E> tag) {
        Object got = this.map.getOrDefault(tag, NONE);
        if (got == NONE) {
            throw new IllegalArgumentException("No value associated with " + tag);
        }
        return (E)got;
    }

    public <E> void put(@Nonnull Tag<E> tag, E value) {
        this.map.put(tag, value);
    }

    public boolean equals(Object o) {
        return o instanceof ItemsByTag && Objects.equals(this.map, ((ItemsByTag)o).map);
    }

    public int hashCode() {
        return Objects.hashCode(this.map);
    }

    public String toString() {
        return "ItemsByTag" + this.map;
    }

    @Nonnull
    Set<Map.Entry<Tag<?>, Object>> entrySet() {
        return this.map.entrySet();
    }
}

