/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.impl.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public final class AllOfAggregationBuilder<T> {
    private final List<Tag> tags = new ArrayList<Tag>();
    private final List<AggregateOperation1> operations = new ArrayList<AggregateOperation1>();

    AllOfAggregationBuilder() {
    }

    @Nonnull
    public <R> Tag<R> add(@Nonnull AggregateOperation1<? super T, ?, R> operation) {
        this.operations.add(operation);
        Tag tag = Tag.tag(this.tags.size());
        this.tags.add(tag);
        return tag;
    }

    @Nonnull
    public AggregateOperation1<T, Object[], ItemsByTag> build() {
        return this.build(FunctionEx.identity());
    }

    @Nonnull
    public <R> AggregateOperation1<T, Object[], R> build(@Nonnull FunctionEx<ItemsByTag, R> exportFinishFn) {
        Util.checkSerializable(exportFinishFn, "exportFinishFn");
        List<Tag> tags = this.tags;
        List<AggregateOperation1> operations = this.operations;
        return AggregateOperation.withCreate(() -> {
            Object[] acc = new Object[tags.size()];
            Arrays.setAll(acc, i -> ((AggregateOperation1)operations.get(i)).createFn().get());
            return acc;
        }).andAccumulate((acc, item) -> {
            for (int i = 0; i < ((Object[])acc).length; ++i) {
                ((AggregateOperation1)operations.get(i)).accumulateFn().accept(acc[i], item);
            }
        }).andCombine(operations.stream().anyMatch(o -> o.combineFn() == null) ? null : (acc1, acc2) -> {
            for (int i = 0; i < ((Object[])acc1).length; ++i) {
                ((AggregateOperation1)operations.get(i)).combineFn().accept(acc1[i], acc2[i]);
            }
        }).andDeduct(operations.stream().anyMatch(o -> o.deductFn() == null) ? null : (acc1, acc2) -> {
            for (int i = 0; i < ((Object[])acc1).length; ++i) {
                ((AggregateOperation1)operations.get(i)).deductFn().accept(acc1[i], acc2[i]);
            }
        }).andExport(acc -> {
            ItemsByTag result = new ItemsByTag();
            for (int i = 0; i < tags.size(); ++i) {
                Object exportedVal = ((AggregateOperation1)operations.get(i)).exportFn().apply(acc[i]);
                result.put((Tag)tags.get(i), exportedVal);
            }
            return exportFinishFn.apply(result);
        }).andFinish(acc -> {
            ItemsByTag result = new ItemsByTag();
            for (int i = 0; i < tags.size(); ++i) {
                Object finishedVal = ((AggregateOperation1)operations.get(i)).finishFn().apply(acc[i]);
                result.put((Tag)tags.get(i), finishedVal);
            }
            return exportFinishFn.apply(result);
        });
    }
}

