/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class JetSubmitJobCodec {
    public static final JetMessageType REQUEST_TYPE = JetMessageType.JET_SUBMITJOB;
    public static final int RESPONSE_TYPE = 100;

    public static ClientMessage encodeRequest(long jobId, Data dag, Data jobConfig) {
        int requiredDataSize = RequestParameters.calculateDataSize(jobId, dag, jobConfig);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Jet.submitJob");
        clientMessage.set(jobId);
        clientMessage.set(dag);
        clientMessage.set(jobConfig);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        long jobId = 0L;
        parameters.jobId = jobId = clientMessage.getLong();
        Data dag = null;
        parameters.dag = dag = clientMessage.getData();
        Data jobConfig = null;
        parameters.jobConfig = jobConfig = clientMessage.getData();
        return parameters;
    }

    public static ClientMessage encodeResponse() {
        int requiredDataSize = ResponseParameters.calculateDataSize();
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(100);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        return parameters;
    }

    public static class ResponseParameters {
        public static int calculateDataSize() {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final JetMessageType TYPE = REQUEST_TYPE;
        public long jobId;
        public Data dag;
        public Data jobConfig;

        public static int calculateDataSize(long jobId, Data dag, Data jobConfig) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 8;
            dataSize += ParameterUtil.calculateDataSize(dag);
            return dataSize += ParameterUtil.calculateDataSize(jobConfig);
        }
    }
}

