/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.function.BiConsumerEx;
import com.hazelcast.jet.function.ConsumerEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;

public final class SinkBuilder<W, T> {
    private final FunctionEx<? super Processor.Context, ? extends W> createFn;
    private final String name;
    private BiConsumerEx<? super W, ? super T> receiveFn;
    private ConsumerEx<? super W> flushFn = ConsumerEx.noop();
    private ConsumerEx<? super W> destroyFn = ConsumerEx.noop();
    private int preferredLocalParallelism = 1;

    private SinkBuilder(@Nonnull String name, @Nonnull FunctionEx<? super Processor.Context, ? extends W> createFn) {
        Util.checkSerializable(createFn, "createFn");
        this.name = name;
        this.createFn = createFn;
    }

    @Nonnull
    public static <W> SinkBuilder<W, Void> sinkBuilder(@Nonnull String name, @Nonnull FunctionEx<Processor.Context, ? extends W> createFn) {
        return new SinkBuilder(name, createFn);
    }

    @Nonnull
    public <T_NEW> SinkBuilder<W, T_NEW> receiveFn(@Nonnull BiConsumerEx<? super W, ? super T_NEW> receiveFn) {
        Util.checkSerializable(receiveFn, "receiveFn");
        SinkBuilder newThis = this;
        newThis.receiveFn = receiveFn;
        return newThis;
    }

    @Nonnull
    public SinkBuilder<W, T> flushFn(@Nonnull ConsumerEx<? super W> flushFn) {
        Util.checkSerializable(flushFn, "flushFn");
        this.flushFn = flushFn;
        return this;
    }

    @Nonnull
    public SinkBuilder<W, T> destroyFn(@Nonnull ConsumerEx<? super W> destroyFn) {
        Util.checkSerializable(destroyFn, "destroyFn");
        this.destroyFn = destroyFn;
        return this;
    }

    @Nonnull
    public SinkBuilder<W, T> preferredLocalParallelism(int preferredLocalParallelism) {
        Vertex.checkLocalParallelism(preferredLocalParallelism);
        this.preferredLocalParallelism = preferredLocalParallelism;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        Preconditions.checkNotNull(this.receiveFn, "receiveFn must be set");
        SupplierEx<Processor> supplier = SinkProcessors.writeBufferedP(this.createFn, this.receiveFn, this.flushFn, this.destroyFn);
        return new SinkImpl(this.name, ProcessorMetaSupplier.of(supplier, this.preferredLocalParallelism));
    }
}

