/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.ConstantFunctionEx;
import javax.annotation.Nonnull;

public class GlobalRollingAggregateTransform<T, R>
extends AbstractTransform {
    @Nonnull
    private final AggregateOperation1<? super T, ?, ? extends R> aggrOp;
    @Nonnull
    private final TriFunction<? super T, Integer, ? super R, ? extends R> mapToOutputFn;

    public GlobalRollingAggregateTransform(@Nonnull Transform upstream, @Nonnull AggregateOperation1<? super T, ?, ? extends R> aggrOp, @Nonnull TriFunction<? super T, Integer, ? super R, ? extends R> mapToOutputFn) {
        super("rolling-aggregate", upstream);
        this.aggrOp = aggrOp;
        this.mapToOutputFn = mapToOutputFn;
    }

    @Override
    public void addToDag(Planner p) {
        ConstantFunctionEx keyFn = new ConstantFunctionEx(this.name().hashCode());
        Planner.PlannerVertex pv = p.addVertex((Transform)this, this.name(), this.localParallelism(), Processors.rollingAggregateP(keyFn, this.aggrOp, this.mapToOutputFn));
        p.addEdges((Transform)this, pv.v, edge -> edge.partitioned(keyFn).distributed());
    }
}

