/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.BiFunctionEx;
import com.hazelcast.jet.function.BiPredicateEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.processor.ProcessorWrapper;
import com.hazelcast.jet.impl.util.WrappingProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class FunctionAdapter {
    @Nonnull
    <T, K> FunctionEx<?, ? extends K> adaptKeyFn(@Nonnull FunctionEx<? super T, ? extends K> keyFn) {
        return keyFn;
    }

    @Nonnull
    <T, R> FunctionEx<?, ?> adaptMapFn(@Nonnull FunctionEx<? super T, ? extends R> mapFn) {
        return mapFn;
    }

    @Nonnull
    <T> PredicateEx<?> adaptFilterFn(@Nonnull PredicateEx<? super T> filterFn) {
        return filterFn;
    }

    @Nonnull
    <T, R> FunctionEx<?, ? extends Traverser<?>> adaptFlatMapFn(@Nonnull FunctionEx<? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return flatMapFn;
    }

    @Nonnull
    <C, T, R> BiFunctionEx<? super C, ?, ?> adaptMapUsingContextFn(@Nonnull BiFunctionEx<? super C, ? super T, ? extends R> mapFn) {
        return mapFn;
    }

    @Nonnull
    <C, T> BiPredicateEx<? super C, ?> adaptFilterUsingContextFn(@Nonnull BiPredicateEx<? super C, ? super T> filterFn) {
        return filterFn;
    }

    @Nonnull
    <C, T, R> BiFunctionEx<? super C, ?, ? extends Traverser<?>> adaptFlatMapUsingContextFn(@Nonnull BiFunctionEx<? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return flatMapFn;
    }

    @Nonnull
    <C, T, R> BiFunctionEx<? super C, ?, ? extends CompletableFuture<Traverser<?>>> adaptFlatMapUsingContextAsyncFn(@Nonnull BiFunctionEx<? super C, ? super T, ? extends CompletableFuture<Traverser<R>>> flatMapAsyncFn) {
        return flatMapAsyncFn;
    }

    @Nonnull
    <T, R extends CharSequence> FunctionEx<?, ? extends R> adaptToStringFn(@Nonnull FunctionEx<? super T, ? extends R> toStringFn) {
        return toStringFn;
    }

    @Nonnull
    public <K, T0, T1, T1_OUT> JoinClause<? extends K, ?, ? super T1, ? extends T1_OUT> adaptJoinClause(@Nonnull JoinClause<? extends K, ? super T0, ? super T1, ? extends T1_OUT> joinClause) {
        return joinClause;
    }

    @Nonnull
    public <T, T1, R> BiFunctionEx<?, ? super T1, ?> adaptHashJoinOutputFn(@Nonnull BiFunctionEx<? super T, ? super T1, ? extends R> mapToOutputFn) {
        return mapToOutputFn;
    }

    @Nonnull
    <T, T1, T2, R> TriFunction<?, ? super T1, ? super T2, ?> adaptHashJoinOutputFn(@Nonnull TriFunction<? super T, ? super T1, ? super T2, ? extends R> mapToOutputFn) {
        return mapToOutputFn;
    }

    @Nonnull
    <T, A, R> AggregateOperation1<?, A, ? extends R> adaptAggregateOperation1(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        return aggrOp;
    }

    @Nonnull
    <T, K, R, OUT> TriFunction<?, ? super K, ? super R, ?> adaptRollingAggregateOutputFn(@Nonnull BiFunctionEx<? super K, ? super R, ? extends OUT> mapToOutputFn) {
        return (t, k, r) -> mapToOutputFn.apply((Object)k, (Object)r);
    }

    @Nonnull
    public static ProcessorMetaSupplier adaptingMetaSupplier(ProcessorMetaSupplier metaSup, int[] ordinalsToAdapt) {
        return new WrappingProcessorMetaSupplier(metaSup, p -> new AdaptingProcessor((Processor)p, ordinalsToAdapt));
    }

    private static final class AdaptingInbox
    implements Inbox {
        private Inbox wrapped;

        private AdaptingInbox() {
        }

        void setWrappedInbox(@Nonnull Inbox wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public Object peek() {
            return AdaptingInbox.unwrapPayload(this.wrapped.peek());
        }

        @Override
        public Object poll() {
            return AdaptingInbox.unwrapPayload(this.wrapped.poll());
        }

        @Override
        public void remove() {
            this.wrapped.remove();
        }

        private static Object unwrapPayload(Object jetEvent) {
            return jetEvent != null ? ((JetEvent)jetEvent).payload() : null;
        }
    }

    private static final class AdaptingProcessor
    extends ProcessorWrapper {
        private final AdaptingInbox adaptingInbox = new AdaptingInbox();
        private final BitSet shouldAdaptOrdinal = new BitSet();

        AdaptingProcessor(Processor wrapped, int[] ordinalsToAdapt) {
            super(wrapped);
            for (int ordinal : ordinalsToAdapt) {
                this.shouldAdaptOrdinal.set(ordinal);
            }
        }

        @Override
        public void process(int ordinal, @Nonnull Inbox inbox) {
            Inbox inboxToUse;
            if (this.shouldAdaptOrdinal.get(ordinal)) {
                inboxToUse = this.adaptingInbox;
                this.adaptingInbox.setWrappedInbox(inbox);
            } else {
                inboxToUse = inbox;
            }
            super.process(ordinal, inboxToUse);
        }
    }
}

