/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.EventTimeMapper;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.ConsumerEx;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;

public class StreamJmsP<T>
extends AbstractProcessor {
    public static final int PREFERRED_LOCAL_PARALLELISM = 4;
    private final Connection connection;
    private final FunctionEx<? super Connection, ? extends Session> sessionFn;
    private final FunctionEx<? super Session, ? extends MessageConsumer> consumerFn;
    private final ConsumerEx<? super Session> flushFn;
    private final FunctionEx<? super Message, ? extends T> projectionFn;
    private final EventTimeMapper<? super T> eventTimeMapper;
    private Session session;
    private MessageConsumer consumer;
    private Traverser<Object> traverser;

    StreamJmsP(Connection connection, FunctionEx<? super Connection, ? extends Session> sessionFn, FunctionEx<? super Session, ? extends MessageConsumer> consumerFn, ConsumerEx<? super Session> flushFn, FunctionEx<? super Message, ? extends T> projectionFn, EventTimePolicy<? super T> eventTimePolicy) {
        this.connection = connection;
        this.sessionFn = sessionFn;
        this.consumerFn = consumerFn;
        this.flushFn = flushFn;
        this.projectionFn = projectionFn;
        this.eventTimeMapper = new EventTimeMapper<T>(eventTimePolicy);
        this.eventTimeMapper.increasePartitionCount(1);
    }

    @Nonnull
    public static <T> ProcessorSupplier supplier(@Nonnull SupplierEx<? extends Connection> connectionSupplier, @Nonnull FunctionEx<? super Connection, ? extends Session> sessionFn, @Nonnull FunctionEx<? super Session, ? extends MessageConsumer> consumerFn, @Nonnull ConsumerEx<? super Session> flushFn, @Nonnull FunctionEx<? super Message, ? extends T> projectionFn, @Nonnull EventTimePolicy<? super T> eventTimePolicy) {
        return new Supplier(connectionSupplier, sessionFn, consumerFn, flushFn, projectionFn, eventTimePolicy);
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        this.session = this.sessionFn.apply((Connection)this.connection);
        this.consumer = this.consumerFn.apply((Session)this.session);
        this.traverser = ((Traverser<Message>)() -> Util.uncheckCall(() -> this.consumer.receiveNoWait())).flatMap(t -> this.eventTimeMapper.flatMapEvent(this.projectionFn.apply((Message)t), 0, StreamJmsP.handleJmsTimestamp(t))).peek(item -> this.flushFn.accept((Session)this.session));
    }

    private static long handleJmsTimestamp(Message msg) {
        try {
            return msg.getJMSTimestamp() == 0L ? Long.MIN_VALUE : msg.getJMSTimestamp();
        }
        catch (JMSException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    public boolean complete() {
        this.emitFromTraverser(this.traverser);
        return false;
    }

    @Override
    public void close() throws Exception {
        this.consumer.close();
        this.session.close();
    }

    private static final class Supplier<T>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final SupplierEx<? extends Connection> connectionSupplier;
        private final FunctionEx<? super Connection, ? extends Session> sessionFn;
        private final FunctionEx<? super Session, ? extends MessageConsumer> consumerFn;
        private final ConsumerEx<? super Session> flushFn;
        private final FunctionEx<? super Message, ? extends T> projectionFn;
        private final EventTimePolicy<? super T> eventTimePolicy;
        private transient Connection connection;

        private Supplier(SupplierEx<? extends Connection> connectionSupplier, FunctionEx<? super Connection, ? extends Session> sessionFn, FunctionEx<? super Session, ? extends MessageConsumer> consumerFn, ConsumerEx<? super Session> flushFn, FunctionEx<? super Message, ? extends T> projectionFn, EventTimePolicy<? super T> eventTimePolicy) {
            this.connectionSupplier = connectionSupplier;
            this.sessionFn = sessionFn;
            this.consumerFn = consumerFn;
            this.flushFn = flushFn;
            this.projectionFn = projectionFn;
            this.eventTimePolicy = eventTimePolicy;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
            this.connection = this.connectionSupplier.get();
            this.connection.start();
        }

        @Override
        public void close(@Nullable Throwable error) throws Exception {
            if (this.connection != null) {
                this.connection.close();
            }
        }

        @Override
        @Nonnull
        public Collection<? extends Processor> get(int count) {
            return IntStream.range(0, count).mapToObj(i -> new StreamJmsP<T>(this.connection, this.sessionFn, this.consumerFn, this.flushFn, this.projectionFn, this.eventTimePolicy)).collect(Collectors.toList());
        }
    }
}

