/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.Cluster;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import javax.annotation.Nonnull;

public class ClusterMetadata
implements IdentifiedDataSerializable {
    private String name;
    private String version;
    private long clusterTime;
    private int state;

    public ClusterMetadata() {
    }

    public ClusterMetadata(String name, Cluster cluster) {
        this.name = name;
        this.version = BuildInfoProvider.getBuildInfo().getJetBuildInfo().getVersion();
        this.state = cluster.getClusterState().ordinal();
        this.clusterTime = cluster.getClusterTime();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public ClusterState getState() {
        return ClusterState.values()[this.state];
    }

    public int getStateOrdinal() {
        return this.state;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public long getClusterTime() {
        return this.clusterTime;
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 36;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setClusterTime(long clusterTime) {
        this.clusterTime = clusterTime;
    }

    public void setState(int state) {
        this.state = state;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.version);
        out.writeInt(this.state);
        out.writeLong(this.clusterTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.version = in.readUTF();
        this.state = in.readInt();
        this.clusterTime = in.readLong();
    }

    public String toString() {
        return "ClusterSummary{name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", clusterTime=" + this.clusterTime + ", state=" + (Object)((Object)ClusterState.values()[this.state]) + '}';
    }
}

