/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetExportSnapshotCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobConfigCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobStatusCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobSubmissionTimeCodec;
import com.hazelcast.client.impl.protocol.codec.JetJoinSubmittedJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetResumeJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetSubmitJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetTerminateJobCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.AbstractJobProxy;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;

public class ClientJobProxy
extends AbstractJobProxy<JetClientInstanceImpl> {
    ClientJobProxy(JetClientInstanceImpl client, long jobId) {
        super(client, jobId);
    }

    ClientJobProxy(JetClientInstanceImpl client, long jobId, DAG dag, JobConfig config) {
        super(client, jobId, dag, config);
    }

    @Override
    @Nonnull
    public JobStatus getStatus() {
        ClientMessage request = JetGetJobStatusCodec.encodeRequest(this.getId());
        try {
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterAddress()).invoke().get();
            JetGetJobStatusCodec.ResponseParameters parameters = JetGetJobStatusCodec.decodeResponse(response);
            return JobStatus.values()[parameters.response];
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    protected ICompletableFuture<Void> invokeSubmitJob(Data dag, JobConfig config) {
        Object configData = this.serializationService().toData(config);
        ClientMessage request = JetSubmitJobCodec.encodeRequest(this.getId(), dag, configData);
        return new CancellableFuture<ClientMessage>(this.invocation(request, this.masterAddress()).invoke());
    }

    @Override
    protected ICompletableFuture<Void> invokeJoinJob() {
        ClientMessage request = JetJoinSubmittedJobCodec.encodeRequest(this.getId());
        return new CancellableFuture<ClientMessage>(this.invocation(request, this.masterAddress()).invoke());
    }

    @Override
    protected ICompletableFuture<Void> invokeTerminateJob(TerminationMode mode) {
        ClientMessage request = JetTerminateJobCodec.encodeRequest(this.getId(), mode.ordinal());
        return new CancellableFuture<ClientMessage>(this.invocation(request, this.masterAddress()).invoke());
    }

    @Override
    public void resume() {
        ClientMessage request = JetResumeJobCodec.encodeRequest(this.getId());
        try {
            new CancellableFuture<ClientMessage>(this.invocation(request, this.masterAddress()).invoke()).get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public JobStateSnapshot cancelAndExportSnapshot(String name) {
        return this.doExportSnapshot(name, true);
    }

    @Override
    public JobStateSnapshot exportSnapshot(String name) {
        return this.doExportSnapshot(name, false);
    }

    private JobStateSnapshot doExportSnapshot(String name, boolean cancelJob) {
        ClientMessage request = JetExportSnapshotCodec.encodeRequest(this.getId(), name, cancelJob);
        try {
            new CancellableFuture<ClientMessage>(this.invocation(request, this.masterAddress()).invoke()).get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return ((JetClientInstanceImpl)this.container()).getJobStateSnapshot(name);
    }

    @Override
    protected long doGetJobSubmissionTime() {
        ClientMessage request = JetGetJobSubmissionTimeCodec.encodeRequest(this.getId());
        try {
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterAddress()).invoke().get();
            return JetGetJobSubmissionTimeCodec.decodeResponse((ClientMessage)response).response;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    protected JobConfig doGetJobConfig() {
        ClientMessage request = JetGetJobConfigCodec.encodeRequest(this.getId());
        try {
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterAddress()).invoke().get();
            Data data = JetGetJobConfigCodec.decodeResponse((ClientMessage)response).response;
            return (JobConfig)this.serializationService().toObject(data);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    protected Address masterAddress() {
        Optional first = ((JetClientInstanceImpl)this.container()).getCluster().getMembers().stream().findFirst();
        return ((Member)first.orElseThrow(() -> new IllegalStateException("No members found in cluster"))).getAddress();
    }

    @Override
    protected SerializationService serializationService() {
        return ((JetClientInstanceImpl)this.container()).getHazelcastClient().getSerializationService();
    }

    @Override
    protected LoggingService loggingService() {
        return ((JetClientInstanceImpl)this.container()).getHazelcastClient().getLoggingService();
    }

    private ClientInvocation invocation(ClientMessage request, Address invocationAddr) {
        return new ClientInvocation(((JetClientInstanceImpl)this.container()).getHazelcastClient(), request, "jobId=" + this.getIdString(), invocationAddr);
    }

    private static class CancellableFuture<T>
    implements ICompletableFuture<Void> {
        private final ICompletableFuture<T> future;

        CancellableFuture(ICompletableFuture<T> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.future.get();
            return null;
        }

        @Override
        public Void get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.future.get(timeout, unit);
            return null;
        }

        @Override
        public void andThen(final ExecutionCallback<Void> callback) {
            this.future.andThen(new ExecutionCallback<T>(){

                @Override
                public void onResponse(T response) {
                    callback.onResponse(null);
                }

                @Override
                public void onFailure(Throwable t) {
                    callback.onFailure(t);
                }
            });
        }

        @Override
        public void andThen(final ExecutionCallback<Void> callback, Executor executor) {
            this.future.andThen(new ExecutionCallback<T>(){

                @Override
                public void onResponse(T response) {
                    callback.onResponse(null);
                }

                @Override
                public void onFailure(Throwable t) {
                    callback.onFailure(t);
                }
            }, executor);
        }
    }
}

