/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;

public interface WatermarkPolicy {
    public long reportEvent(long var1);

    public long getCurrentWatermark();

    @Nonnull
    public static SupplierEx<WatermarkPolicy> limitingLag(final long lag) {
        Preconditions.checkNotNegative(lag, "lag must not be negative");
        return () -> new WatermarkPolicy(){
            private long wm = Long.MIN_VALUE;

            @Override
            public long reportEvent(long timestamp) {
                if (timestamp < Long.MIN_VALUE + lag) {
                    return Long.MIN_VALUE;
                }
                this.wm = Math.max(this.wm, timestamp - lag);
                return this.wm;
            }

            @Override
            public long getCurrentWatermark() {
                return this.wm;
            }
        };
    }
}

