/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.core.IMap;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBiPredicate;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.function.DistributedToLongFunction;
import com.hazelcast.jet.function.DistributedTriFunction;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.ContextFactories;
import com.hazelcast.jet.pipeline.ContextFactory;
import com.hazelcast.jet.pipeline.GeneralHashJoinBuilder;
import com.hazelcast.jet.pipeline.GeneralStageWithKey;
import com.hazelcast.jet.pipeline.JoinClause;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkStage;
import com.hazelcast.jet.pipeline.Stage;
import com.hazelcast.jet.pipeline.StreamStage;
import javax.annotation.Nonnull;

public interface GeneralStage<T>
extends Stage {
    @Nonnull
    public <R> GeneralStage<R> map(@Nonnull DistributedFunction<? super T, ? extends R> var1);

    @Nonnull
    public GeneralStage<T> filter(@Nonnull DistributedPredicate<T> var1);

    @Nonnull
    public <R> GeneralStage<R> flatMap(@Nonnull DistributedFunction<? super T, ? extends Traverser<? extends R>> var1);

    @Nonnull
    public <C, R> GeneralStage<R> mapUsingContext(@Nonnull ContextFactory<C> var1, @Nonnull DistributedBiFunction<? super C, ? super T, ? extends R> var2);

    @Nonnull
    public <C> GeneralStage<T> filterUsingContext(@Nonnull ContextFactory<C> var1, @Nonnull DistributedBiPredicate<? super C, ? super T> var2);

    @Nonnull
    public <C, R> GeneralStage<R> flatMapUsingContext(@Nonnull ContextFactory<C> var1, @Nonnull DistributedBiFunction<? super C, ? super T, ? extends Traverser<? extends R>> var2);

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingReplicatedMap(@Nonnull String mapName, @Nonnull DistributedBiFunction<? super ReplicatedMap<K, V>, ? super T, ? extends R> mapFn) {
        return this.mapUsingContext(ContextFactories.replicatedMapContext(mapName), mapFn);
    }

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingReplicatedMap(@Nonnull ReplicatedMap<K, V> replicatedMap, @Nonnull DistributedBiFunction<? super ReplicatedMap<K, V>, ? super T, ? extends R> mapFn) {
        return this.mapUsingReplicatedMap(replicatedMap.getName(), mapFn);
    }

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingIMap(@Nonnull String mapName, @Nonnull DistributedBiFunction<? super IMap<K, V>, ? super T, ? extends R> mapFn) {
        return this.mapUsingContext(ContextFactories.iMapContext(mapName), mapFn);
    }

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingIMap(@Nonnull IMap<K, V> iMap, @Nonnull DistributedBiFunction<? super IMap<K, V>, ? super T, ? extends R> mapFn) {
        return this.mapUsingIMap(iMap.getName(), mapFn);
    }

    @Nonnull
    public <R> GeneralStage<R> rollingAggregate(@Nonnull AggregateOperation1<? super T, ?, ? extends R> var1);

    @Nonnull
    public <K, T1_IN, T1, R> GeneralStage<R> hashJoin(@Nonnull BatchStage<T1_IN> var1, @Nonnull JoinClause<K, ? super T, ? super T1_IN, ? extends T1> var2, @Nonnull DistributedBiFunction<T, T1, R> var3);

    @Nonnull
    public <K1, K2, T1_IN, T2_IN, T1, T2, R> GeneralStage<R> hashJoin2(@Nonnull BatchStage<T1_IN> var1, @Nonnull JoinClause<K1, ? super T, ? super T1_IN, ? extends T1> var2, @Nonnull BatchStage<T2_IN> var3, @Nonnull JoinClause<K2, ? super T, ? super T2_IN, ? extends T2> var4, @Nonnull DistributedTriFunction<T, T1, T2, R> var5);

    @Nonnull
    public GeneralHashJoinBuilder<T> hashJoinBuilder();

    @Nonnull
    public <K> GeneralStageWithKey<T, K> groupingKey(@Nonnull DistributedFunction<? super T, ? extends K> var1);

    @Nonnull
    default public StreamStage<T> addTimestamps() {
        return this.addTimestamps(t -> System.currentTimeMillis(), 0L);
    }

    @Nonnull
    public StreamStage<T> addTimestamps(@Nonnull DistributedToLongFunction<? super T> var1, long var2);

    @Nonnull
    public SinkStage drainTo(@Nonnull Sink<? super T> var1);

    @Nonnull
    public GeneralStage<T> peek(@Nonnull DistributedPredicate<? super T> var1, @Nonnull DistributedFunction<? super T, ? extends CharSequence> var2);

    @Nonnull
    default public GeneralStage<T> peek(@Nonnull DistributedFunction<? super T, ? extends CharSequence> toStringFn) {
        return this.peek(DistributedPredicate.alwaysTrue(), toStringFn);
    }

    @Nonnull
    default public GeneralStage<T> peek() {
        return this.peek(DistributedPredicate.alwaysTrue(), Object::toString);
    }

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull DistributedSupplier<Processor> var2);
}

