/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedTriFunction;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import javax.annotation.Nonnull;

public class RollingAggregateTransform<T, K, R, OUT>
extends AbstractTransform {
    private final DistributedFunction<? super T, ? extends K> keyFn;
    @Nonnull
    private final AggregateOperation1<? super T, ?, ? extends R> aggrOp;
    @Nonnull
    private final DistributedTriFunction<? super T, ? super K, ? super R, ? extends OUT> mapToOutputFn;

    public RollingAggregateTransform(@Nonnull Transform upstream, @Nonnull DistributedFunction<? super T, ? extends K> keyFn, @Nonnull AggregateOperation1<? super T, ?, ? extends R> aggrOp, @Nonnull DistributedTriFunction<? super T, ? super K, ? super R, ? extends OUT> mapToOutputFn) {
        super("rolling-aggregate", upstream);
        this.keyFn = keyFn;
        this.aggrOp = aggrOp;
        this.mapToOutputFn = mapToOutputFn;
    }

    @Override
    public void addToDag(Planner p) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, p.uniqueVertexName(this.name(), ""), this.localParallelism(), Processors.rollingAggregateP(this.keyFn, this.aggrOp, this.mapToOutputFn));
        p.addEdges((Transform)this, pv.v, edge -> edge.partitioned(this.keyFn).distributed());
    }
}

