/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.core.processor.DiagnosticProcessors;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import javax.annotation.Nonnull;

public class PeekTransform<T>
extends AbstractTransform {
    @Nonnull
    public final DistributedPredicate<? super T> shouldLogFn;
    @Nonnull
    public final DistributedFunction<? super T, ? extends CharSequence> toStringFn;

    public PeekTransform(@Nonnull Transform upstream, @Nonnull DistributedPredicate<? super T> shouldLogFn, @Nonnull DistributedFunction<? super T, ? extends CharSequence> toStringFn) {
        super("peek", upstream);
        this.shouldLogFn = shouldLogFn;
        this.toStringFn = toStringFn;
    }

    @Override
    public void addToDag(Planner p) {
        Planner.PlannerVertex peekedPv = p.xform2vertex.get(this.upstream().get(0));
        p.xform2vertex.put(this, peekedPv);
        peekedPv.v.updateMetaSupplier(sup -> DiagnosticProcessors.peekOutputP(this.toStringFn, this.shouldLogFn, sup));
    }
}

