/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBiPredicate;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.function.DistributedTriFunction;
import com.hazelcast.jet.function.KeyedWindowResultFunction;
import com.hazelcast.jet.function.WindowResultFunction;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.Arrays;
import javax.annotation.Nonnull;

class JetEventFunctionAdapter
extends FunctionAdapter {
    JetEventFunctionAdapter() {
    }

    @Nonnull
    <T, K> DistributedFunction<? super JetEvent<T>, ? extends K> adaptKeyFn(@Nonnull DistributedFunction<? super T, ? extends K> keyFn) {
        return e -> keyFn.apply((Object)e.payload());
    }

    @Nonnull
    <T, R> DistributedFunction<? super JetEvent<T>, ?> adaptMapFn(@Nonnull DistributedFunction<? super T, ? extends R> mapFn) {
        return e -> JetEvent.jetEvent(mapFn.apply((Object)e.payload()), e.timestamp());
    }

    @Nonnull
    <T> DistributedPredicate<? super JetEvent<T>> adaptFilterFn(@Nonnull DistributedPredicate<? super T> filterFn) {
        return e -> filterFn.test((Object)e.payload());
    }

    @Nonnull
    <T, R> DistributedFunction<? super JetEvent<T>, ? extends Traverser<?>> adaptFlatMapFn(@Nonnull DistributedFunction<? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return e -> ((Traverser)flatMapFn.apply((Object)e.payload())).map(r -> JetEvent.jetEvent(r, e.timestamp()));
    }

    @Nonnull
    <C, T, R> DistributedBiFunction<? super C, ? super JetEvent<T>, ? extends JetEvent<R>> adaptMapUsingContextFn(@Nonnull DistributedBiFunction<? super C, ? super T, ? extends R> mapFn) {
        return (context, e) -> JetEvent.jetEvent(mapFn.apply((Object)context, (Object)e.payload()), e.timestamp());
    }

    @Nonnull
    <C, T> DistributedBiPredicate<? super C, ? super JetEvent<T>> adaptFilterUsingContextFn(@Nonnull DistributedBiPredicate<? super C, ? super T> filterFn) {
        return (context, e) -> filterFn.test((Object)context, (Object)e.payload());
    }

    @Nonnull
    <C, T, R> DistributedBiFunction<? super C, ? super JetEvent<T>, ? extends Traverser<JetEvent<R>>> adaptFlatMapUsingContextFn(@Nonnull DistributedBiFunction<? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return (context, e) -> ((Traverser)flatMapFn.apply((Object)context, (Object)e.payload())).map(r -> JetEvent.jetEvent(r, e.timestamp()));
    }

    @Nonnull
    <T, STR extends CharSequence> DistributedFunction<? super JetEvent<T>, ? extends STR> adaptToStringFn(@Nonnull DistributedFunction<? super T, ? extends STR> toStringFn) {
        return e -> (CharSequence)toStringFn.apply((Object)e.payload());
    }

    @Nonnull
    public <K, T0, T1, T1_OUT> JoinClause<? extends K, ? super JetEvent<T0>, ? super T1, ? extends T1_OUT> adaptJoinClause(@Nonnull JoinClause<? extends K, ? super T0, ? super T1, ? extends T1_OUT> joinClause) {
        return JoinClause.onKeys(this.adaptKeyFn(joinClause.leftKeyFn()), joinClause.rightKeyFn()).projecting(joinClause.rightProjectFn());
    }

    @Nonnull
    public <T, T1, R> DistributedBiFunction<? super JetEvent<T>, ? super T1, ?> adaptHashJoinOutputFn(@Nonnull DistributedBiFunction<? super T, ? super T1, ? extends R> mapToOutputFn) {
        return (e, t1) -> JetEvent.jetEvent(mapToOutputFn.apply((Object)e.payload(), (Object)t1), e.timestamp());
    }

    @Nonnull
    <T, T1, T2, R> DistributedTriFunction<? super JetEvent<T>, ? super T1, ? super T2, ?> adaptHashJoinOutputFn(@Nonnull DistributedTriFunction<? super T, ? super T1, ? super T2, ? extends R> mapToOutputFn) {
        return (e, t1, t2) -> JetEvent.jetEvent(mapToOutputFn.apply((Object)e.payload(), (Object)t1, (Object)t2), e.timestamp());
    }

    @Nonnull
    <R, OUT> WindowResultFunction<? super R, ? extends JetEvent<OUT>> adaptWindowResultFn(@Nonnull WindowResultFunction<? super R, ? extends OUT> windowResultFn) {
        return (winStart, winEnd, windowResult) -> JetEvent.jetEvent(windowResultFn.apply(winStart, winEnd, windowResult), winEnd - 1L);
    }

    @Nonnull
    <K, R, OUT> KeyedWindowResultFunction<? super K, ? super R, ? extends JetEvent<OUT>> adaptKeyedWindowResultFn(@Nonnull KeyedWindowResultFunction<? super K, ? super R, ? extends OUT> keyedWindowResultFn) {
        return (winStart, winEnd, key, windowResult) -> JetEvent.jetEvent(keyedWindowResultFn.apply(winStart, winEnd, key, windowResult), winEnd - 1L);
    }

    @Nonnull
    <T, K, R, OUT> DistributedTriFunction<? super JetEvent<T>, ? super K, ? super R, ? extends JetEvent<OUT>> adaptRollingAggregateOutputFn(@Nonnull DistributedBiFunction<? super K, ? super R, ? extends OUT> mapToOutputFn) {
        return (jetEvent, key, result) -> JetEvent.jetEvent(mapToOutputFn.apply((Object)key, (Object)result), jetEvent.timestamp());
    }

    @Nonnull
    <A, R> AggregateOperation<A, ? extends R> adaptAggregateOperation(@Nonnull AggregateOperation<A, ? extends R> aggrOp) {
        if (aggrOp instanceof AggregateOperation1) {
            return this.adaptAggregateOperation1((AggregateOperation1)aggrOp);
        }
        if (aggrOp instanceof AggregateOperation2) {
            return JetEventFunctionAdapter.adaptAggregateOperation2((AggregateOperation2)aggrOp);
        }
        if (aggrOp instanceof AggregateOperation3) {
            return JetEventFunctionAdapter.adaptAggregateOperation3((AggregateOperation3)aggrOp);
        }
        DistributedBiConsumer[] adaptedAccFns = new DistributedBiConsumer[aggrOp.arity()];
        Arrays.setAll(adaptedAccFns, i -> JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn(i)));
        return aggrOp.withAccumulateFns(adaptedAccFns);
    }

    @Nonnull
    <T, A, R> AggregateOperation1<? super JetEvent<T>, A, ? extends R> adaptAggregateOperation1(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        return aggrOp.withAccumulateFn(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn()));
    }

    @Nonnull
    static <T0, T1, A, R> AggregateOperation2<? super JetEvent<T0>, ? super JetEvent<T1>, A, ? extends R> adaptAggregateOperation2(@Nonnull AggregateOperation2<? super T0, ? super T1, A, ? extends R> aggrOp) {
        return aggrOp.withAccumulateFn0(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn0())).withAccumulateFn1(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn1()));
    }

    @Nonnull
    static <T0, T1, T2, A, R> AggregateOperation3<? super JetEvent<T0>, ? super JetEvent<T1>, ? super JetEvent<T2>, A, ? extends R> adaptAggregateOperation3(@Nonnull AggregateOperation3<? super T0, ? super T1, ? super T2, A, ? extends R> aggrOp) {
        return aggrOp.withAccumulateFn0(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn0())).withAccumulateFn1(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn1())).withAccumulateFn2(JetEventFunctionAdapter.adaptAccumulateFn(aggrOp.accumulateFn2()));
    }

    @Nonnull
    private static <A, T> DistributedBiConsumer<? super A, ? super JetEvent<T>> adaptAccumulateFn(@Nonnull DistributedBiConsumer<? super A, ? super T> accumulateFn) {
        return (acc, t) -> accumulateFn.accept((Object)acc, (Object)t.payload());
    }
}

