/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.KeyedWindowResultFunction;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.pipeline.BatchStageImpl;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.JetEventFunctionAdapter;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.StageWithGroupingBase;
import com.hazelcast.jet.impl.pipeline.StreamStageImpl;
import com.hazelcast.jet.impl.pipeline.transform.GroupTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.pipeline.transform.WindowGroupTransform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.BatchStageWithKey;
import com.hazelcast.jet.pipeline.StageWithKeyAndWindow;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.jet.pipeline.StreamStageWithKey;
import com.hazelcast.jet.pipeline.WindowDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class GrAggBuilder<K> {
    private final PipelineImpl pipelineImpl;
    private final WindowDefinition wDef;
    private final List<ComputeStageImplBase> upstreamStages = new ArrayList<ComputeStageImplBase>();
    private final List<DistributedFunction<?, ? extends K>> keyFns = new ArrayList();

    public GrAggBuilder(BatchStageWithKey<?, K> stage0) {
        ComputeStageImplBase computeStage = ((StageWithGroupingBase)((Object)stage0)).computeStage;
        this.pipelineImpl = (PipelineImpl)computeStage.getPipeline();
        this.wDef = null;
        this.upstreamStages.add(computeStage);
        this.keyFns.add(stage0.keyFn());
    }

    public GrAggBuilder(StageWithKeyAndWindow<?, K> stage) {
        ComputeStageImplBase computeStage = ((StageWithGroupingBase)((Object)stage)).computeStage;
        ComputeStageImplBase.ensureJetEvents(computeStage, "This pipeline stage");
        this.pipelineImpl = (PipelineImpl)computeStage.getPipeline();
        this.wDef = stage.windowDefinition();
        this.upstreamStages.add(computeStage);
        this.keyFns.add(stage.keyFn());
    }

    public <T> Tag<T> add(StreamStageWithKey<T, K> stage) {
        ComputeStageImplBase computeStage = ((StageWithGroupingBase)((Object)stage)).computeStage;
        ComputeStageImplBase.ensureJetEvents(computeStage, "This pipeline stage");
        this.upstreamStages.add(computeStage);
        this.keyFns.add(stage.keyFn());
        return Tag.tag(this.upstreamStages.size() - 1);
    }

    public <E> Tag<E> add(BatchStageWithKey<E, K> stage) {
        this.upstreamStages.add(((StageWithGroupingBase)((Object)stage)).computeStage);
        this.keyFns.add(stage.keyFn());
        return Tag.tag(this.upstreamStages.size() - 1);
    }

    public <A, R, OUT> BatchStage<OUT> buildBatch(@Nonnull AggregateOperation<A, ? extends R> aggrOp, @Nonnull DistributedBiFunction<? super K, ? super R, OUT> mapToOutputFn) {
        Util.checkSerializable(mapToOutputFn, "mapToOutputFn");
        List<Transform> upstreamTransforms = this.upstreamStages.stream().map(s -> s.transform).collect(Collectors.toList());
        GroupTransform<? super K, A, ? super R, OUT> transform = new GroupTransform<K, A, R, OUT>(upstreamTransforms, this.keyFns, aggrOp, mapToOutputFn);
        this.pipelineImpl.connect(upstreamTransforms, transform);
        return new BatchStageImpl(transform, this.pipelineImpl);
    }

    public <A, R, OUT> StreamStage<OUT> buildStream(@Nonnull AggregateOperation<A, ? extends R> aggrOp, @Nonnull KeyedWindowResultFunction<? super K, ? super R, OUT> mapToOutputFn) {
        Util.checkSerializable(mapToOutputFn, "mapToOutputFn");
        List<Transform> upstreamTransforms = this.upstreamStages.stream().map(s -> s.transform).collect(Collectors.toList());
        JetEventFunctionAdapter fnAdapter = ComputeStageImplBase.ADAPT_TO_JET_EVENT;
        ArrayList adaptedKeyFns = new ArrayList();
        for (DistributedFunction<?, ? extends K> distributedFunction : this.keyFns) {
            adaptedKeyFns.add(fnAdapter.adaptKeyFn(distributedFunction));
        }
        WindowGroupTransform<? super K, ? super R, JetEvent<OUT>> transform = new WindowGroupTransform<K, R, JetEvent<OUT>>(upstreamTransforms, this.wDef, adaptedKeyFns, fnAdapter.adaptAggregateOperation(aggrOp), fnAdapter.adaptKeyedWindowResultFn(mapToOutputFn));
        this.pipelineImpl.connect(upstreamTransforms, transform);
        return new StreamStageImpl(transform, fnAdapter, this.pipelineImpl);
    }
}

