/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.operation.AbstractJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class SubmitJobOperation
extends AbstractJobOperation
implements IdentifiedDataSerializable {
    private Data dag;
    private JobConfig config;

    public SubmitJobOperation() {
    }

    public SubmitJobOperation(long jobId, Data dag, JobConfig config) {
        super(jobId);
        this.dag = dag;
        this.config = config;
    }

    @Override
    public void run() {
        JetService service = (JetService)this.getService();
        JobCoordinationService coordinationService = service.getJobCoordinationService();
        coordinationService.submitJob(this.jobId(), this.dag, this.config);
    }

    @Override
    public int getId() {
        return 8;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.dag);
        out.writeObject(this.config);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.dag = in.readData();
        this.config = (JobConfig)in.readObject();
    }
}

