/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Partition;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.impl.util.CircularListCursor;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class ReadWithPartitionIteratorP<T>
extends AbstractProcessor {
    private static final boolean PREFETCH_VALUES = true;
    private static final int FETCH_SIZE = 16384;
    private final Traverser<T> outputTraverser;

    ReadWithPartitionIteratorP(Function<? super Integer, ? extends Iterator<T>> partitionToIterator, List<Integer> partitions) {
        CircularListCursor iteratorCursor = new CircularListCursor(partitions.stream().map(partitionToIterator).collect(Collectors.toList()));
        this.outputTraverser = () -> {
            do {
                Iterator currIterator = (Iterator)iteratorCursor.value();
                while (currIterator.hasNext()) {
                    Object next = currIterator.next();
                    if (next == null) continue;
                    iteratorCursor.advance();
                    return next;
                }
                iteratorCursor.remove();
            } while (iteratorCursor.advance());
            return null;
        };
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    public static <T> ProcessorMetaSupplier readMapSupplier(@Nonnull String mapName) {
        return new LocalClusterMetaSupplier(instance -> partition -> ((MapProxyImpl)instance.getMap(mapName)).iterator(16384, (int)partition, true));
    }

    public static <T> ProcessorMetaSupplier readRemoteMapSupplier(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return new RemoteClusterMetaSupplier(clientConfig, instance -> partition -> ((ClientMapProxy)instance.getMap(mapName)).iterator(16384, (int)partition, true));
    }

    public static <K, V, T> ProcessorMetaSupplier readMapSupplier(@Nonnull String mapName, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        Util.checkSerializable(predicate, "predicate");
        Util.checkSerializable(projection, "projection");
        return new LocalClusterMetaSupplier(instance -> partition -> {
            MapProxyImpl map = (MapProxyImpl)instance.getMap(mapName);
            return map.iterator(16384, (int)partition, projection, predicate);
        });
    }

    public static <K, V, T> ProcessorMetaSupplier readRemoteMapSupplier(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection, @Nonnull Predicate<? super K, ? super V> predicate) {
        Util.checkSerializable(projection, "projection");
        Util.checkSerializable(predicate, "predicate");
        return new RemoteClusterMetaSupplier(clientConfig, instance -> partition -> ((ClientMapProxy)instance.getMap(mapName)).iterator(16384, (int)partition, projection, predicate));
    }

    public static ProcessorMetaSupplier readCacheSupplier(@Nonnull String cacheName) {
        return new LocalClusterMetaSupplier(instance -> partition -> ((CacheProxy)instance.getCacheManager().getCache(cacheName)).iterator(16384, (int)partition, true));
    }

    public static ProcessorMetaSupplier readRemoteCacheSupplier(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return new RemoteClusterMetaSupplier(clientConfig, instance -> partition -> ((ClientCacheProxy)instance.getCacheManager().getCache(cacheName)).iterator(16384, (int)partition, true));
    }

    @Override
    public boolean complete() {
        return this.emitFromTraverser(this.outputTraverser);
    }

    private static <T> List<Processor> getProcessors(int count, List<Integer> ownedPartitions, Function<? super Integer, ? extends Iterator<T>> partitionToIterator) {
        return Util.processorToPartitions(count, ownedPartitions).values().stream().map(partitions -> !partitions.isEmpty() ? new ReadWithPartitionIteratorP(partitionToIterator, (List<Integer>)partitions) : Processors.noopP().get()).collect(Collectors.toList());
    }

    private static class LocalClusterProcessorSupplier<T>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final List<Integer> ownedPartitions;
        private final DistributedFunction<? super HazelcastInstance, ? extends Function<Integer, Iterator<T>>> iteratorSupplier;
        private transient Function<Integer, Iterator<T>> partitionToIterator;

        LocalClusterProcessorSupplier(List<Integer> ownedPartitions, DistributedFunction<? super HazelcastInstance, ? extends Function<Integer, Iterator<T>>> iteratorSupplier) {
            this.ownedPartitions = ownedPartitions != null ? ownedPartitions : Collections.emptyList();
            this.iteratorSupplier = iteratorSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.partitionToIterator = this.iteratorSupplier.apply(context.jetInstance().getHazelcastInstance());
        }

        @Nonnull
        public List<Processor> get(int count) {
            return ReadWithPartitionIteratorP.getProcessors(count, this.ownedPartitions, this.partitionToIterator);
        }
    }

    private static class LocalClusterMetaSupplier<T>
    implements ProcessorMetaSupplier {
        static final long serialVersionUID = 1L;
        private final DistributedFunction<? super HazelcastInstance, ? extends Function<Integer, Iterator<T>>> iteratorSupplier;
        private transient Map<Address, List<Integer>> addrToPartitions;

        LocalClusterMetaSupplier(DistributedFunction<? super HazelcastInstance, ? extends Function<Integer, Iterator<T>>> iteratorSupplier) {
            this.iteratorSupplier = iteratorSupplier;
        }

        @Override
        public int preferredLocalParallelism() {
            return 2;
        }

        @Override
        public void init(@Nonnull ProcessorMetaSupplier.Context context) {
            this.addrToPartitions = context.jetInstance().getHazelcastInstance().getPartitionService().getPartitions().stream().collect(Collectors.groupingBy(p -> p.getOwner().getAddress(), Collectors.mapping(Partition::getPartitionId, Collectors.toList())));
        }

        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            return address -> new LocalClusterProcessorSupplier(this.addrToPartitions.get(address), this.iteratorSupplier);
        }
    }

    private static class RemoteClusterProcessorSupplier<T>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final List<Integer> ownedPartitions;
        private final String clientXml;
        private final DistributedFunction<? super HazelcastInstance, ? extends Function<Integer, Iterator<T>>> iteratorSupplier;
        private transient HazelcastInstance client;
        private transient Function<? super Integer, ? extends Iterator<T>> partitionToIterator;

        RemoteClusterProcessorSupplier(List<Integer> ownedPartitions, String clientXml, DistributedFunction<? super HazelcastInstance, ? extends Function<Integer, Iterator<T>>> iteratorSupplier) {
            this.ownedPartitions = ownedPartitions;
            this.clientXml = clientXml;
            this.iteratorSupplier = iteratorSupplier;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.client = HazelcastClient.newHazelcastClient(Util.asClientConfig(this.clientXml));
            this.partitionToIterator = this.iteratorSupplier.apply(this.client);
        }

        @Override
        public void close(Throwable error) {
            if (this.client != null) {
                this.client.shutdown();
            }
        }

        @Nonnull
        public List<Processor> get(int count) {
            return ReadWithPartitionIteratorP.getProcessors(count, this.ownedPartitions, this.partitionToIterator);
        }
    }

    private static class RemoteClusterMetaSupplier<T>
    implements ProcessorMetaSupplier {
        static final long serialVersionUID = 1L;
        private final String clientXml;
        private final DistributedFunction<? super HazelcastInstance, ? extends Function<Integer, Iterator<T>>> iteratorSupplier;
        private transient int remotePartitionCount;

        RemoteClusterMetaSupplier(ClientConfig clientConfig, DistributedFunction<? super HazelcastInstance, ? extends Function<Integer, Iterator<T>>> iteratorSupplier) {
            this.clientXml = Util.asXmlString(clientConfig);
            this.iteratorSupplier = iteratorSupplier;
        }

        @Override
        public int preferredLocalParallelism() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(@Nonnull ProcessorMetaSupplier.Context context) {
            HazelcastInstance client = HazelcastClient.newHazelcastClient(Util.asClientConfig(this.clientXml));
            try {
                HazelcastClientProxy clientProxy = (HazelcastClientProxy)client;
                this.remotePartitionCount = clientProxy.client.getClientPartitionService().getPartitionCount();
            }
            finally {
                client.shutdown();
            }
        }

        @Nonnull
        public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            Map<Address, List<Integer>> membersToPartitions = IntStream.range(0, this.remotePartitionCount).boxed().collect(Collectors.groupingBy(partition -> (Address)addresses.get(partition % addresses.size())));
            return address -> new RemoteClusterProcessorSupplier((List)membersToPartitions.get(address), this.clientXml, this.iteratorSupplier);
        }
    }
}

