/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.function;

import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface TriPredicate<T, U, V> {
    public boolean test(T var1, U var2, V var3);

    default public TriPredicate<T, U, V> and(@Nonnull TriPredicate<? super T, ? super U, ? super V> other) {
        Preconditions.checkNotNull(other, "other");
        return (t, u, v) -> this.test(t, u, v) && other.test(t, u, v);
    }

    default public TriPredicate<T, U, V> negate() {
        return (t, u, v) -> !this.test(t, u, v);
    }

    default public TriPredicate<T, U, V> or(@Nonnull TriPredicate<? super T, ? super U, ? super V> other) {
        Preconditions.checkNotNull(other, "other");
        return (t, u, v) -> this.test(t, u, v) || other.test(t, u, v);
    }
}

