/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;

public class MetricsConfig {
    public static final int DEFAULT_METRICS_COLLECTION_SECONDS = 5;
    public static final int DEFAULT_METRICS_RETENTION_SECONDS = 5;
    private boolean enabled = true;
    private boolean jmxEnabled = true;
    private int retentionSeconds = 5;
    private boolean metricsForDataStructures;
    private int intervalSeconds = 5;

    @Nonnull
    public MetricsConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    @Nonnull
    public MetricsConfig setRetentionSeconds(int retentionSeconds) {
        Preconditions.checkPositive(this.intervalSeconds, "retentionSeconds must be positive");
        this.retentionSeconds = retentionSeconds;
        return this;
    }

    public int getRetentionSeconds() {
        return this.retentionSeconds;
    }

    @Nonnull
    public MetricsConfig setCollectionIntervalSeconds(int intervalSeconds) {
        Preconditions.checkPositive(intervalSeconds, "intervalSeconds must be positive");
        this.intervalSeconds = intervalSeconds;
        return this;
    }

    public int getCollectionIntervalSeconds() {
        return this.intervalSeconds;
    }

    @Nonnull
    public MetricsConfig setMetricsForDataStructures(boolean metricsForDataStructures) {
        this.metricsForDataStructures = metricsForDataStructures;
        return this;
    }

    public boolean isMetricsForDataStructures() {
        return this.metricsForDataStructures;
    }
}

