/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperationBuilder;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.aggregate.AggregateOperation1Impl;
import com.hazelcast.jet.impl.util.Util;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AggregateOperation<A, R>
extends Serializable {
    public int arity();

    @Nonnull
    public DistributedSupplier<A> createFn();

    @Nonnull
    default public <T> DistributedBiConsumer<? super A, ? super T> accumulateFn(@Nonnull Tag<T> tag) {
        return this.accumulateFn(tag.index());
    }

    @Nonnull
    public <T> DistributedBiConsumer<? super A, ? super T> accumulateFn(int var1);

    @Nullable
    public DistributedBiConsumer<? super A, ? super A> combineFn();

    @Nullable
    public DistributedBiConsumer<? super A, ? super A> deductFn();

    @Nonnull
    public DistributedFunction<? super A, ? extends R> exportFn();

    @Nonnull
    default public DistributedFunction<? super A, ? extends R> finishFn() {
        return this.exportFn();
    }

    @Nonnull
    public AggregateOperation<A, R> withAccumulateFns(DistributedBiConsumer ... var1);

    @Nonnull
    public AggregateOperation<A, A> withIdentityFinish();

    @Nonnull
    default public <T> AggregateOperation1<T, A, R> withCombiningAccumulateFn(@Nonnull DistributedFunction<T, A> getAccFn) {
        DistributedBiConsumer combineFn = Objects.requireNonNull(this.combineFn(), "The 'combine' primitive is missing");
        return new AggregateOperation1Impl<Object, Object, R>(this.createFn(), (acc, item) -> combineFn.accept(acc, getAccFn.apply(item)), combineFn, this.deductFn(), this.exportFn(), this.finishFn());
    }

    @Nonnull
    public <R_NEW> AggregateOperation<A, R_NEW> andThen(DistributedFunction<? super R, ? extends R_NEW> var1);

    @Nonnull
    public static <A> AggregateOperationBuilder<A> withCreate(@Nonnull DistributedSupplier<A> createFn) {
        Util.checkSerializable(createFn, "createFn");
        return new AggregateOperationBuilder<A>(createFn);
    }
}

