/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Map;

final class QueryUtil {
    private QueryUtil() {
    }

    static Predicate<Object, Object> toPredicate(Object[] left, int[] leftEquiJoinIndices, int[] rightEquiJoinIndices, QueryPath[] rightPaths) {
        PredicateBuilder builder = Predicates.newPredicateBuilder();
        PredicateBuilder.EntryObject entryObject = builder.getEntryObject();
        for (int i = 0; i < leftEquiJoinIndices.length; ++i) {
            PredicateBuilder.EntryObject object;
            Comparable<?> leftValue = QueryUtil.asComparable(left[leftEquiJoinIndices[i]]);
            if (leftValue == null) {
                return null;
            }
            QueryPath rightPath = rightPaths[rightEquiJoinIndices[i]];
            if (rightPath.isKey()) {
                object = rightPath.isTop() ? entryObject.key() : entryObject.key().get(rightPath.getPath());
            } else {
                PredicateBuilder.EntryObject entryObject2 = object = rightPath.isTop() ? entryObject.get(rightPath.toString()) : entryObject.get(QueryPath.VALUE).get(rightPath.getPath());
            }
            if (i == 0) {
                object.equal(leftValue);
                continue;
            }
            builder.and((Predicate)object.equal(leftValue));
        }
        return builder;
    }

    private static Comparable<?> asComparable(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        throw QueryException.error((String)("JOIN not supported for " + value.getClass() + ": not comparable"));
    }

    static Projection<Map.Entry<Object, Object>, Object[]> toProjection(KvRowProjector.Supplier rightRowProjectorSupplier) {
        return new JoinProjection(rightRowProjectorSupplier);
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
    private static final class JoinProjection
    implements Projection<Map.Entry<Object, Object>, Object[]>,
    DataSerializable,
    SerializationServiceAware {
        private KvRowProjector.Supplier rightRowProjectorSupplier;
        private transient InternalSerializationService serializationService;
        private transient Extractors extractors;

        private JoinProjection() {
        }

        private JoinProjection(KvRowProjector.Supplier rightRowProjectorSupplier) {
            this.rightRowProjectorSupplier = rightRowProjectorSupplier;
        }

        public Object[] transform(Map.Entry<Object, Object> entry) {
            return this.rightRowProjectorSupplier.get(this.serializationService, this.extractors).project(entry);
        }

        public void setSerializationService(SerializationService serializationService) {
            this.serializationService = (InternalSerializationService)serializationService;
            this.extractors = Extractors.newBuilder((InternalSerializationService)this.serializationService).build();
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.rightRowProjectorSupplier);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.rightRowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
        }
    }
}

