/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.JetConventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.FilterLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FilterPhysicalRel;
import java.util.Collection;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;

final class FilterPhysicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new FilterPhysicalRule();

    private FilterPhysicalRule() {
        super(FilterPhysicalRule.operand(FilterLogicalRel.class, (RelTrait)JetConventions.LOGICAL, (RelOptRuleOperandChildren)FilterPhysicalRule.some((RelOptRuleOperand)FilterPhysicalRule.operand(RelNode.class, (RelOptRuleOperandChildren)FilterPhysicalRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0])), FilterPhysicalRule.class.getSimpleName());
    }

    public void onMatch(RelOptRuleCall call) {
        FilterLogicalRel logicalFilter = (FilterLogicalRel)call.rel(0);
        RelNode input = logicalFilter.getInput();
        RelNode convertedInput = OptUtils.toPhysicalInput(input);
        Collection<RelNode> transformedInputs = OptUtils.extractPhysicalRelsFromSubset(convertedInput);
        for (RelNode transformedInput : transformedInputs) {
            FilterPhysicalRel rel = new FilterPhysicalRel(logicalFilter.getCluster(), transformedInput.getTraitSet(), transformedInput, logicalFilter.getCondition());
            call.transformTo((RelNode)rel);
        }
    }
}

