/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class KvMetadataResolvers {
    private static final Pattern EXT_NAME_PATTERN = Pattern.compile("((" + QueryPath.KEY + "|" + QueryPath.VALUE + ")\\.)?[^.]+");
    private final Map<String, KvMetadataResolver> keyResolvers;
    private final Map<String, KvMetadataResolver> valueResolvers;

    public KvMetadataResolvers(KvMetadataResolver ... resolvers) {
        this(resolvers, resolvers);
    }

    public KvMetadataResolvers(KvMetadataResolver[] keyResolvers, KvMetadataResolver[] valueResolvers) {
        this.keyResolvers = this.resolversMap(keyResolvers);
        this.valueResolvers = this.resolversMap(valueResolvers);
    }

    private Map<String, KvMetadataResolver> resolversMap(KvMetadataResolver[] resolvers) {
        return Arrays.stream(resolvers).flatMap(resolver -> resolver.supportedFormats().map(format -> Util.entry((Object)format, (Object)resolver))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public List<MappingField> resolveAndValidateFields(List<MappingField> userFields, Map<String, String> options, NodeEngine nodeEngine) {
        InternalSerializationService ss = (InternalSerializationService)nodeEngine.getSerializationService();
        for (MappingField field2 : userFields) {
            String name = field2.name();
            String extName = field2.externalName();
            if (extName == null) {
                extName = name.equals(QueryPath.KEY) || name.equals(QueryPath.VALUE) ? name : QueryPath.VALUE_PREFIX + name;
                field2.setExternalName(name);
            }
            if (EXT_NAME_PATTERN.matcher(extName).matches()) continue;
            throw QueryException.error((String)("Invalid external name: " + extName));
        }
        List<MappingField> keyFields = this.findMetadataResolver(options, true).resolveAndValidateFields(true, userFields, options, ss);
        List<MappingField> valueFields = this.findMetadataResolver(options, false).resolveAndValidateFields(false, userFields, options, ss);
        Map fields = Stream.concat(keyFields.stream(), valueFields.stream()).collect(LinkedHashMap::new, (map, field) -> map.putIfAbsent(field.name(), field), Map::putAll);
        if (fields.isEmpty()) {
            throw QueryException.error((String)"The resolved field list is empty");
        }
        return new ArrayList<MappingField>(fields.values());
    }

    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        KvMetadataResolver resolver = this.findMetadataResolver(options, isKey);
        return Objects.requireNonNull(resolver.resolveMetadata(isKey, resolvedFields, options, serializationService));
    }

    private KvMetadataResolver findMetadataResolver(Map<String, String> options, boolean isKey) {
        String option;
        String format;
        KvMetadataResolver resolver = (isKey ? this.keyResolvers : this.valueResolvers).get(format = options.get(option = isKey ? "keyFormat" : "valueFormat"));
        if (resolver == null) {
            if (format == null) {
                throw QueryException.error((String)("Missing '" + option + "' option"));
            }
            throw QueryException.error((String)("Unsupported serialization format: " + format));
        }
        return resolver;
    }

    public static Map<QueryPath, MappingField> extractFields(List<MappingField> fields, boolean isKey) {
        LinkedHashMap<QueryPath, MappingField> fieldsByPath = new LinkedHashMap<QueryPath, MappingField>();
        for (MappingField field : fields) {
            QueryPath path = QueryPath.create((String)field.externalName());
            if (isKey != path.isKey() || fieldsByPath.putIfAbsent(path, field) == null) continue;
            throw QueryException.error((String)("Duplicate external name: " + path));
        }
        return fieldsByPath;
    }

    public static void maybeAddDefaultField(boolean isKey, @Nonnull List<MappingField> resolvedFields, @Nonnull List<TableField> tableFields) {
        String fieldName;
        String string = fieldName = isKey ? QueryPath.KEY : QueryPath.VALUE;
        if (resolvedFields.stream().noneMatch(f -> f.externalName().equals(fieldName) || f.name().equals(fieldName))) {
            tableFields.add((TableField)new MapTableField(fieldName, QueryDataType.OBJECT, true, QueryPath.create((String)fieldName)));
        }
    }
}

