/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MappingDefinition {
    private final Table table;
    private final String type;
    private final Map<String, String> options;

    public MappingDefinition(Table table, String type, Map<String, String> options) {
        this.table = table;
        this.type = type;
        this.options = options;
    }

    public String schema() {
        return this.table.getSchemaName();
    }

    public String name() {
        return this.table.getSqlName();
    }

    public String type() {
        return this.type;
    }

    public List<TableField> fields() {
        return this.table.getFields();
    }

    public String options() {
        return this.options.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }
}

