/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.sql.impl.connector.infoschema.InfoSchemaTable;
import com.hazelcast.jet.sql.impl.schema.MappingDefinition;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MappingColumnsTable
extends InfoSchemaTable {
    private static final String NAME = "columns";
    private static final List<TableField> FIELDS = Arrays.asList(new TableField("table_catalog", QueryDataType.VARCHAR, false), new TableField("table_schema", QueryDataType.VARCHAR, false), new TableField("table_name", QueryDataType.VARCHAR, false), new TableField("column_name", QueryDataType.VARCHAR, false), new TableField("ordinal_position", QueryDataType.INT, false), new TableField("is_nullable", QueryDataType.VARCHAR, false), new TableField("data_type", QueryDataType.VARCHAR, false));
    private final String catalog;
    private final List<MappingDefinition> definitions;

    public MappingColumnsTable(String catalog, String schemaName, List<MappingDefinition> definitions) {
        super(FIELDS, schemaName, NAME, (TableStatistics)new ConstantTableStatistics((long)(definitions.size() * FIELDS.size())));
        this.catalog = catalog;
        this.definitions = definitions;
    }

    @Override
    protected List<Object[]> rows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.definitions.size());
        for (MappingDefinition definition : this.definitions) {
            List<TableField> fields = definition.fields();
            for (int i = 0; i < fields.size(); ++i) {
                TableField field = fields.get(i);
                Object[] row = new Object[]{this.catalog, definition.schema(), definition.name(), field.getName(), i, String.valueOf(true), field.getType().getTypeFamily().name()};
                rows.add(row);
            }
        }
        return rows;
    }
}

